/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.integration;

import de.markusbordihn.playercompanions.data.Experience;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.time.Instant;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.UsernameCache;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ElementHelper;

public class PlayerCompanionEntityProvider
implements IEntityComponentProvider {
    public static final PlayerCompanionEntityProvider INSTANCE = new PlayerCompanionEntityProvider();
    public static final ResourceLocation UID = new ResourceLocation("player_companions", "player_companion_entity_provider");

    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        PlayerCompanionEntity playerCompanionEntity;
        Entity entity = accessor.getEntity();
        if (entity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)entity).m_6084_()) {
            tooltip.add((Component)Component.m_237113_((String)("Type: " + playerCompanionEntity.getCompanionType())));
            tooltip.add((Component)Component.m_237113_((String)("Variant: " + playerCompanionEntity.getVariant())));
            if (playerCompanionEntity.m_269323_() != null) {
                PlayerCompanionData data = PlayerCompanionsClientData.getCompanion((LivingEntity)playerCompanionEntity);
                if (accessor.getEntity() instanceof OwnableEntity) {
                    String ownerName = UsernameCache.getLastKnownUsername((UUID)playerCompanionEntity.m_21805_());
                    if (ownerName == null) {
                        LivingEntity owner = playerCompanionEntity.m_269323_();
                        UUID ownerUUID = playerCompanionEntity.m_21805_();
                        ownerName = owner != null ? owner.m_7755_().getString() : (ownerUUID != null ? ownerUUID.toString() : "Unknown");
                    }
                    tooltip.add((Component)Component.m_237113_((String)("Owner: " + ownerName)));
                }
                tooltip.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_level", (Object[])new Object[]{playerCompanionEntity.getExperienceLevel(), playerCompanionEntity.getExperience(), Experience.getExperienceForNextLevel(playerCompanionEntity.getExperienceLevel())}));
                if (data != null) {
                    long respawnTimer = (long)data.getEntityRespawnTimer() - Instant.now().getEpochSecond();
                    if (respawnTimer <= 0L) {
                        if (data.isOrderedToPosition()) {
                            tooltip.add((Component)Component.m_237113_((String)"Order: To Position"));
                        }
                        if (data.isOrderedToSit()) {
                            tooltip.add((Component)Component.m_237113_((String)"Order: Sitting"));
                        } else {
                            tooltip.add((Component)Component.m_237113_((String)"Order: Following"));
                        }
                    }
                    if (respawnTimer >= 0L) {
                        tooltip.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_respawn", (Object[])new Object[]{respawnTimer}).m_130940_(ChatFormatting.RED));
                    }
                    tooltip.add((Component)Component.m_237113_((String)("Aggression Level: " + data.getEntityAggressionLevel().name())));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IElement getIcon(EntityAccessor accessor, IPluginConfig config, IElement currentIcon) {
        ItemStack itemStack;
        PlayerCompanionEntity playerCompanionEntity;
        Entity entity = accessor.getEntity();
        if (entity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)entity).m_6084_() && !(itemStack = new ItemStack((ItemLike)playerCompanionEntity.getCompanionItem())).m_41619_()) {
            return new ElementHelper().item(itemStack, 2.0f);
        }
        return null;
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

