/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.item;

import de.markusbordihn.playercompanions.data.Experience;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionSpawnManager;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.text.TranslatableText;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapturedCompanion
extends Item {
    public static final String COMPANION_UUID_TAG = "CompanionUUID";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private PlayerCompanionVariant variant = PlayerCompanionVariant.DEFAULT;

    public CapturedCompanion() {
        this(new Item.Properties().m_41487_(1).m_41503_(16));
    }

    public CapturedCompanion(PlayerCompanionVariant variant) {
        this();
        this.variant = variant;
    }

    public CapturedCompanion(Item.Properties properties) {
        super(properties);
    }

    public static UUID getCompanionUUID(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128403_(COMPANION_UUID_TAG)) {
            return compoundTag.m_128342_(COMPANION_UUID_TAG);
        }
        return null;
    }

    public boolean hasCompanion(ItemStack itemStack) {
        return CapturedCompanion.getCompanionUUID(itemStack) != null;
    }

    private CompoundTag setCompanionUUID(ItemStack itemStack, UUID uuid) {
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128362_(COMPANION_UUID_TAG, uuid);
        return compoundTag;
    }

    public PlayerCompanionVariant getVariant() {
        return this.variant;
    }

    public boolean despawnCompanion(LivingEntity livingEntity, ItemStack itemStack) {
        PlayerCompanionEntity playerCompanionEntity;
        UUID capturedCompanionUUID = CapturedCompanion.getCompanionUUID(itemStack);
        if (!(livingEntity instanceof PlayerCompanionEntity) || !(playerCompanionEntity = (PlayerCompanionEntity)livingEntity).m_20148_().equals(capturedCompanionUUID)) {
            return false;
        }
        return PlayerCompanionSpawnManager.despawn(livingEntity);
    }

    public boolean createTamedCompanion(ItemStack itemStack, Player player, Level level) {
        Entity entity;
        EntityType<?> entityType = this.getEntityType();
        if (entityType != null && (entity = entityType.m_20615_(level)) instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            if (this.variant != null && this.variant != PlayerCompanionVariant.NONE) {
                playerCompanionEntity.setVariant(this.variant);
            }
            if (itemStack.m_41788_()) {
                playerCompanionEntity.m_6593_(itemStack.m_41786_());
            }
            playerCompanionEntity.finalizeSpawn();
            playerCompanionEntity.m_21828_(player);
            playerCompanionEntity.follow();
            this.setCompanionUUID(itemStack, entity.m_20148_());
            return true;
        }
        return false;
    }

    public EntityType<?> getEntityType() {
        return null;
    }

    public Ingredient getEntityFood() {
        return null;
    }

    public Component m_7626_(ItemStack itemStack) {
        PlayerCompanionData playerCompanion = PlayerCompanionsClientData.getCompanion(itemStack);
        if (playerCompanion != null) {
            return Component.m_237115_((String)this.m_5671_(itemStack)).m_7220_((Component)Component.m_237113_((String)(": " + playerCompanion.getName())));
        }
        return Component.m_237115_((String)this.m_5671_(itemStack));
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        Level level = player.m_9236_();
        if (!this.hasCompanion(itemStack)) {
            PlayerCompanionEntity playerCompanionEntity;
            if (!level.m_5776_() && livingEntity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)livingEntity).m_21824_() && player.m_20148_().equals(playerCompanionEntity.m_21805_())) {
                if (playerCompanionEntity.m_6095_().equals(this.getEntityType()) && (playerCompanionEntity.getVariant().equals((Object)this.getVariant()) || playerCompanionEntity.getVariant() == PlayerCompanionVariant.NONE && this.getVariant() == PlayerCompanionVariant.DEFAULT)) {
                    log.info("Player {} linked {} with {}", (Object)player, (Object)itemStack, (Object)playerCompanionEntity);
                    ItemStack handItemStack = player.m_21120_(hand);
                    this.setCompanionUUID(handItemStack, playerCompanionEntity.m_20148_());
                    return InteractionResult.CONSUME;
                }
                log.debug("Player companion type {} and variant {} is not compatible with item type {} and variant {}!", (Object)playerCompanionEntity.m_6095_(), (Object)playerCompanionEntity.getVariant(), this.getEntityType(), (Object)this.getVariant());
            }
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && this.despawnCompanion(livingEntity, itemStack)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.FAIL;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = context.m_43723_();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos blockPos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        if (!this.hasCompanion(itemStack) && !this.createTamedCompanion(itemStack, player, level)) {
            return InteractionResult.FAIL;
        }
        if (!PlayerCompanionsServerData.get().hasCompanion(itemStack)) {
            log.error("Unable to find player companion with UUID {} for item {}", (Object)CapturedCompanion.getCompanionUUID(itemStack), (Object)itemStack);
            player.m_213846_((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_warning_not_found", (Object[])new Object[]{CapturedCompanion.getCompanionUUID(itemStack), itemStack}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return InteractionResult.FAIL;
        }
        PlayerCompanionData playerCompanionData = PlayerCompanionsServerData.get().getCompanion(itemStack);
        if (playerCompanionData != null && !player.m_20148_().equals(playerCompanionData.getOwnerUUID())) {
            player.m_213846_((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_warning_not_owner", (Object[])new Object[]{playerCompanionData.getName(), playerCompanionData.getUUID(), playerCompanionData.getOwnerName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return InteractionResult.FAIL;
        }
        if (playerCompanionData != null && playerCompanionData.hasEntityRespawnTimer() && (long)playerCompanionData.getEntityRespawnTimer() > Instant.now().getEpochSecond()) {
            player.m_213846_((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_warning_respawn_timer", (Object[])new Object[]{playerCompanionData.getName(), playerCompanionData.getUUID(), (long)playerCompanionData.getEntityRespawnTimer() - Instant.now().getEpochSecond()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return InteractionResult.FAIL;
        }
        if (PlayerCompanionSpawnManager.spawn(itemStack, serverPlayer, serverLevel, blockPos)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_142522_(ItemStack itemStack) {
        PlayerCompanionData playerCompanionData = PlayerCompanionsClientData.getCompanion(itemStack);
        return playerCompanionData != null;
    }

    public int m_8105_(ItemStack itemStack) {
        return 32000;
    }

    public int m_142158_(ItemStack itemStack) {
        PlayerCompanionData playerCompanionData = PlayerCompanionsClientData.getCompanion(itemStack);
        if (playerCompanionData != null) {
            return Math.round(playerCompanionData.getEntityHealth() * (13.0f / playerCompanionData.getEntityHealthMax()));
        }
        return super.m_142158_(itemStack);
    }

    public int m_142159_(ItemStack itemStack) {
        PlayerCompanionData playerCompanionData = PlayerCompanionsClientData.getCompanion(itemStack);
        if (playerCompanionData != null) {
            float barColor = Math.max(0.0f, playerCompanionData.getEntityHealth() / playerCompanionData.getEntityHealthMax());
            return Mth.m_14169_((float)(barColor / 3.0f), (float)1.0f, (float)1.0f);
        }
        return super.m_142159_(itemStack);
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedCompanion) {
            UUID uuid;
            CapturedCompanion capturedCompanion = (CapturedCompanion)item;
            PlayerCompanionData playerCompanionData = PlayerCompanionsClientData.getCompanion(itemStack);
            if (playerCompanionData != null) {
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_name", (Object[])new Object[]{playerCompanionData.getName()}).m_130940_(ChatFormatting.GOLD));
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_health", (Object[])new Object[]{Float.valueOf(playerCompanionData.getEntityHealth()), Float.valueOf(playerCompanionData.getEntityHealthMax())}));
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_owner", (Object[])new Object[]{playerCompanionData.getOwnerName()}));
            }
            if (playerCompanionData != null) {
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_type", (Object[])new Object[]{playerCompanionData.getType()}).m_130940_(ChatFormatting.GRAY));
            }
            if (playerCompanionData != null) {
                long respawnTimer;
                if (playerCompanionData.getExperience() > 0) {
                    tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_level", (Object[])new Object[]{playerCompanionData.getExperienceLevel(), playerCompanionData.getExperience(), Experience.getExperienceForNextLevel(playerCompanionData.getExperienceLevel())}));
                }
                if ((respawnTimer = (long)playerCompanionData.getEntityRespawnTimer() - Instant.now().getEpochSecond()) <= 0L) {
                    if (playerCompanionData.isSittingOnShoulder()) {
                        tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_status_sit_on_shoulder"));
                    } else if (playerCompanionData.isOrderedToPosition()) {
                        tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_status_order_to_position"));
                    } else if (playerCompanionData.isOrderedToSit()) {
                        tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_status_order_to_sit"));
                    } else {
                        tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_status_order_to_follow"));
                    }
                } else {
                    tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_status_dead"));
                }
                if (respawnTimer >= 0L) {
                    tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_respawn", (Object[])new Object[]{respawnTimer}).m_130940_(ChatFormatting.RED));
                }
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.tamed_companion_dimension", (Object[])new Object[]{playerCompanionData.getDimensionName()}).m_130940_(ChatFormatting.GRAY));
            }
            if (CapturedCompanion.getCompanionUUID(itemStack) == null) {
                tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.empty_captured_companion_usage").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltipList.add((Component)Component.m_237110_((String)"text.player_companions.captured_companion_usage", (Object[])new Object[]{playerCompanionData != null ? playerCompanionData.getName() : ""}).m_130940_(ChatFormatting.GRAY));
            }
            if (capturedCompanion.getEntityFood() != null) {
                MutableComponent foodOverview = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
                for (ItemStack foodItemStack : capturedCompanion.getEntityFood().m_43908_()) {
                    foodOverview.m_7220_(TranslatableText.getItemName(foodItemStack)).m_130946_(", ");
                }
                foodOverview.m_130946_("...");
                tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tamed_companion_food").m_130940_(ChatFormatting.GREEN).m_7220_((Component)foodOverview));
            }
            if (playerCompanionData == null && (uuid = CapturedCompanion.getCompanionUUID(itemStack)) != null) {
                tooltipList.add((Component)Component.m_237113_((String)("UUID: " + uuid)).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

