/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.item;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.TameablePlayerCompanion;
import de.markusbordihn.playercompanions.item.CapturedCompanion;
import de.markusbordihn.playercompanions.text.TranslatableText;
import de.markusbordihn.playercompanions.utils.TitleUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompanionTameItem
extends Item {
    public static final Set<String> TAMEABLE_MOB_TYPES = Collections.emptySet();
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");

    public CompanionTameItem() {
        this(new Item.Properties());
    }

    public CompanionTameItem(Item.Properties properties) {
        super(properties);
    }

    public void convertEntityToItem(Item companionItem, ServerPlayer serverPlayer, LivingEntity livingEntity, Level level) {
        log.debug("Capturing mob {} for {} with {}", (Object)livingEntity, (Object)serverPlayer, (Object)companionItem);
        ItemStack itemStack = new ItemStack((ItemLike)companionItem);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128362_("CompanionUUID", livingEntity.m_20148_());
        itemStack.m_41739_(compoundTag);
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof CapturedCompanion)) {
            log.error("Unable to create captured companion item, got {} instead!", (Object)itemStack);
            return;
        }
        ItemStack capturedCompanionItemStack = itemStack.m_41777_();
        Inventory playerInventory = serverPlayer.m_150109_();
        int freeInventorySlot = playerInventory.m_36062_();
        boolean gavePlayerItemStack = false;
        if (freeInventorySlot != -1) {
            gavePlayerItemStack = playerInventory.m_36040_(freeInventorySlot, capturedCompanionItemStack);
            playerInventory.m_6596_();
        }
        if (gavePlayerItemStack && !playerInventory.m_8020_(freeInventorySlot).m_41619_() && playerInventory.m_8020_(freeInventorySlot).m_41720_() instanceof CapturedCompanion && CapturedCompanion.getCompanionUUID(playerInventory.m_8020_(freeInventorySlot)).equals(livingEntity.m_20148_())) {
            log.info("Gave player {} captured companion item {} in slot {} with {}.", (Object)serverPlayer, (Object)playerInventory.m_8020_(freeInventorySlot), (Object)freeInventorySlot, (Object)companionItem);
            TitleUtils.setTitle((Component)Component.m_237110_((String)"text.player_companions.captured_companion_title", (Object[])new Object[]{livingEntity.m_7755_().getString()}), (Component)Component.m_237110_((String)"text.player_companions.captured_companion_subtitle_inventory", (Object[])new Object[]{freeInventorySlot}).m_130940_(ChatFormatting.GRAY), serverPlayer);
        } else {
            BlockPos blockPos = livingEntity.m_20183_();
            if (!level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), itemStack))) {
                log.error("Unable to give item {} to player {} or to drop it to the world {}!", (Object)itemStack, (Object)serverPlayer, (Object)level);
                return;
            }
            log.warn("Dropped captured companion item for {} with {}.", (Object)serverPlayer, (Object)itemStack);
            if (freeInventorySlot == -1) {
                log.warn("Reason: Inventory is full!");
            } else if (playerInventory.m_8020_(freeInventorySlot).m_41720_() instanceof CapturedCompanion) {
                log.warn("Reason: Was not able to store it in the inventory slot {} found captured companion item {} with UUID {} instead!", (Object)freeInventorySlot, (Object)playerInventory.m_8020_(freeInventorySlot).m_41720_(), (Object)CapturedCompanion.getCompanionUUID(playerInventory.m_8020_(freeInventorySlot)));
            } else {
                log.warn("Reason: Was not able to store it in the inventory slot {} found item {} instead!", (Object)freeInventorySlot, (Object)playerInventory.m_8020_(freeInventorySlot));
            }
            TitleUtils.setTitle((Component)Component.m_237110_((String)"text.player_companions.captured_companion_title", (Object[])new Object[]{livingEntity.m_7755_().getString()}), (Component)Component.m_237115_((String)"text.player_companions.captured_companion_subtitle_ground").m_130940_(ChatFormatting.RED), serverPlayer);
        }
        livingEntity.m_142467_(Entity.RemovalReason.DISCARDED);
    }

    public boolean canTameCompanion(LivingEntity livingEntity) {
        PlayerCompanionEntity playerCompanionEntity;
        return livingEntity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)livingEntity).isTamable();
    }

    public boolean canTameCompanionType(String mobType) {
        return !mobType.isEmpty();
    }

    public Set<String> getTameableMobTypes() {
        return TAMEABLE_MOB_TYPES;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.m_21224_()) {
            return InteractionResult.FAIL;
        }
        String mobType = EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString();
        if (!this.canTameCompanion(livingEntity) || !this.canTameCompanionType(mobType)) {
            return InteractionResult.FAIL;
        }
        Level level = player.m_9236_();
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            int maxNumberOfCompanions;
            int numberOfCompanions;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if ((Integer)CompanionTameItem.COMMON.companionLimitPerPlayer.get() > 0 && (numberOfCompanions = PlayerCompanionsServerData.get().getNumberOfCompanions(serverPlayer)) >= (maxNumberOfCompanions = ((Integer)CompanionTameItem.COMMON.companionLimitPerPlayer.get()).intValue())) {
                TitleUtils.setTitle((Component)Component.m_237115_((String)"text.player_companions.max_number_of_companions.title"), (Component)Component.m_237110_((String)"text.player_companions.max_number_of_companions.subtitle", (Object[])new Object[]{numberOfCompanions, maxNumberOfCompanions}).m_130940_(ChatFormatting.RED), serverPlayer);
                return InteractionResult.FAIL;
            }
        }
        if (livingEntity instanceof TameablePlayerCompanion) {
            TameablePlayerCompanion tameablePlayerCompanion = (TameablePlayerCompanion)livingEntity;
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (tameablePlayerCompanion.canTamePlayerCompanion(itemStack, player, livingEntity, hand)) {
                    InteractionResult result = tameablePlayerCompanion.tamePlayerCompanion(itemStack, player, livingEntity, hand);
                    if (result == InteractionResult.SUCCESS) {
                        if (livingEntity instanceof PlayerCompanionEntity) {
                            PlayerCompanionEntity companionEntity = (PlayerCompanionEntity)livingEntity;
                            Item companionItem = companionEntity.getCompanionItem();
                            if (companionItem != null) {
                                this.convertEntityToItem(companionItem, serverPlayer, livingEntity, level);
                            } else {
                                log.error("Unable to capture companion entity {} in item {}!", (Object)livingEntity, (Object)companionItem);
                            }
                        } else {
                            log.error("Capturing of entity {} is not implement!", (Object)livingEntity);
                        }
                    }
                    return result;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return true;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)Component.m_237115_((String)"text.player_companions.tame_companion"));
        Set<String> tameableMobTypes = this.getTameableMobTypes();
        if (!tameableMobTypes.isEmpty()) {
            MutableComponent tameableMobTypeOverview = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
            for (String tamableMob : tameableMobTypes) {
                Component acceptedMobName = TranslatableText.getEntityName(tamableMob);
                if (acceptedMobName == null) continue;
                tameableMobTypeOverview.m_7220_(acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!tameableMobTypeOverview.getString().isBlank()) {
                MutableComponent tameableMobsOverview = Component.m_237115_((String)"text.player_companions.tameable_companions").m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                tameableMobsOverview.m_7220_((Component)tameableMobTypeOverview).m_130946_("...");
                tooltipList.add((Component)tameableMobsOverview);
            }
        }
    }
}

