/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.playercompanions.level.biome.ModBiomeModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ModBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> denylistBiomes, MobSpawnSettings.SpawnerData spawnerData, MobCategory mobCategory) implements BiomeModifier
{
    private static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");

    public static Codec<ModBiomeModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ModBiomeModifier::biomes), (App)Biome.f_47432_.fieldOf("denylist_biomes").forGetter(ModBiomeModifier::denylistBiomes), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(ModBiomeModifier::spawnerData), (App)MobCategory.f_21584_.fieldOf("mob_category").forGetter(ModBiomeModifier::mobCategory)).apply((Applicative)builder, ModBiomeModifier::new));
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && !biome.containsTag(Tags.Biomes.IS_MODIFIED) && !this.denylistBiomes.m_203333_(biome)) {
            this.logSpawn(biome, this.mobCategory, this.spawnerData);
            builder.getMobSpawnSettings().m_48376_(this.mobCategory, this.spawnerData);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBiomeModifiers.ENTITY_MODIFIER_TYPE.get();
    }

    private void logSpawn(Holder<Biome> biome, MobCategory mobCategory, MobSpawnSettings.SpawnerData spawnerData) {
        log.info("{} {} ({}) with weight {}, min {} and max {} in {}{}.", (Object)"\ud83d\udc7e Enable spawn for", (Object)spawnerData.f_48404_, (Object)mobCategory, (Object)spawnerData.m_142631_(), (Object)spawnerData.f_48405_, (Object)spawnerData.f_48406_, (Object)biome.m_203543_(), this.denylistBiomes.m_203632_() > 0 ? " (excluding " + this.denylistBiomes + ")" : "");
    }
}

