/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.network;

import de.markusbordihn.playercompanions.Constants;
import de.markusbordihn.playercompanions.entity.PlayerCompanionCommand;
import de.markusbordihn.playercompanions.network.message.MessageCommandPlayerCompanion;
import de.markusbordihn.playercompanions.network.message.MessagePlayerCompanionData;
import de.markusbordihn.playercompanions.network.message.MessagePlayerCompanionsData;
import de.markusbordihn.playercompanions.network.message.MessageSkinChange;
import de.markusbordihn.playercompanions.skin.SkinType;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class NetworkHandler {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String PROTOCOL_VERSION = "4";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("player_companions", "network"), () -> "4", "4"::equals, "4"::equals);
    private static final ConcurrentHashMap<UUID, ServerPlayer> serverPlayerMap = new ConcurrentHashMap();
    private static int id = 0;
    private static CompoundTag lastCompanionDataPackage;
    private static CompoundTag lastCompanionsDataPackage;

    protected NetworkHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        NetworkHandler.addServerPlayer(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkHandler.addServerPlayer(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NetworkHandler.removeServerPlayer(event.getEntity());
    }

    public static void registerNetworkHandler(FMLCommonSetupEvent event) {
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udc7e Register Player Companions", (Object)INSTANCE, (Object)PROTOCOL_VERSION);
        event.enqueueWork(() -> {
            INSTANCE.registerMessage(id++, MessageCommandPlayerCompanion.class, MessageCommandPlayerCompanion::encode, MessageCommandPlayerCompanion::decode, MessageCommandPlayerCompanion::handle);
            INSTANCE.registerMessage(id++, MessagePlayerCompanionData.class, MessagePlayerCompanionData::encode, MessagePlayerCompanionData::decode, MessagePlayerCompanionData::handle);
            INSTANCE.registerMessage(id++, MessagePlayerCompanionsData.class, MessagePlayerCompanionsData::encode, MessagePlayerCompanionsData::decode, MessagePlayerCompanionsData::handle);
            INSTANCE.registerMessage(id++, MessageSkinChange.class, MessageSkinChange::encode, MessageSkinChange::decode, MessageSkinChange::handle);
        });
    }

    public static void commandPlayerCompanion(String playerCompanionUUID, PlayerCompanionCommand command) {
        if (playerCompanionUUID != null && command != null) {
            INSTANCE.sendToServer((Object)new MessageCommandPlayerCompanion(playerCompanionUUID, command));
        }
    }

    public static void skinChange(UUID uuid, SkinType skinType) {
        if (uuid != null && skinType != null) {
            INSTANCE.sendToServer((Object)new MessageSkinChange(uuid, "", "", Constants.BLANK_UUID, skinType));
        }
    }

    public static void skinChange(UUID uuid, String skin, SkinType skinType) {
        if (uuid != null && skin != null && skinType != null) {
            INSTANCE.sendToServer((Object)new MessageSkinChange(uuid, skin, "", Constants.BLANK_UUID, skinType));
        }
    }

    public static void skinChange(UUID uuid, String skin, String skinURL, UUID skinUUID, SkinType skinType) {
        if (uuid != null && skin != null && skinType != null) {
            INSTANCE.sendToServer((Object)new MessageSkinChange(uuid, skin, skinURL, skinUUID, skinType));
        }
    }

    public static void updatePlayerCompanionsData(UUID ownerUUID, CompoundTag companionsData) {
        if (ownerUUID != null && companionsData != null && !companionsData.m_128456_() && !companionsData.equals((Object)lastCompanionsDataPackage)) {
            ServerPlayer serverPlayer = NetworkHandler.getServerPlayer(ownerUUID);
            if (serverPlayer == null) {
                return;
            }
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessagePlayerCompanionsData(companionsData));
            lastCompanionsDataPackage = companionsData;
        }
    }

    public static void updatePlayerCompanionData(UUID playerCompanionUUID, UUID ownerUUID, CompoundTag companionData) {
        if (playerCompanionUUID != null && ownerUUID != null && companionData != null && !companionData.m_128456_() && !companionData.equals((Object)lastCompanionDataPackage)) {
            ServerPlayer serverPlayer = NetworkHandler.getServerPlayer(ownerUUID);
            if (serverPlayer == null) {
                return;
            }
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessagePlayerCompanionData(playerCompanionUUID.toString(), companionData));
            lastCompanionDataPackage = companionData;
        }
    }

    public static void addServerPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.addServerPlayer(serverPlayer.m_20148_(), serverPlayer);
        }
    }

    public static void addServerPlayer(UUID uuid, ServerPlayer serverPlayer) {
        serverPlayerMap.put(uuid, serverPlayer);
    }

    public static void removeServerPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.removeServerPlayer(serverPlayer.m_20148_());
        }
    }

    public static void removeServerPlayer(UUID uuid) {
        serverPlayerMap.remove(uuid);
    }

    public static ServerPlayer getServerPlayer(UUID uuid) {
        return serverPlayerMap.get(uuid);
    }
}

