/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.network.message;

import de.markusbordihn.playercompanions.entity.PlayerCompanionCommand;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageCommandPlayerCompanion {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected final String playerCompanionUUID;
    protected final PlayerCompanionCommand command;

    public MessageCommandPlayerCompanion(String playerCompanionUUID, PlayerCompanionCommand command) {
        this.playerCompanionUUID = playerCompanionUUID;
        this.command = command;
    }

    public static MessageCommandPlayerCompanion decode(FriendlyByteBuf buffer) {
        return new MessageCommandPlayerCompanion(buffer.m_130277_(), (PlayerCompanionCommand)buffer.m_130066_(PlayerCompanionCommand.class));
    }

    public static void encode(MessageCommandPlayerCompanion message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.playerCompanionUUID);
        buffer.m_130068_((Enum)message.command);
    }

    public static void handle(MessageCommandPlayerCompanion message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageCommandPlayerCompanion.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageCommandPlayerCompanion message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        if (serverPlayer == null) {
            log.error("Unable to get server player for message {} from {}", (Object)message, (Object)context);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)serverPlayer.m_9236_();
        UUID uuid = UUID.fromString(message.getPlayerCompanionUUID());
        Entity entity = serverLevel.m_8791_(uuid);
        PlayerCompanionCommand command = message.getCommand();
        if (command == null) {
            log.error("Unable to get command for message {} from {}", (Object)message, (Object)context);
            return;
        }
        if (entity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            if (serverPlayer.m_20148_().equals(playerCompanionEntity.m_21805_())) {
                log.debug("Player Companion command {} for {} from {}", (Object)command, (Object)playerCompanionEntity, (Object)serverPlayer);
                playerCompanionEntity.handleCommand(command);
            } else {
                log.error("Player {} tried to execute command {} for unowned {}", (Object)serverPlayer, (Object)command, (Object)playerCompanionEntity);
            }
        }
    }

    public PlayerCompanionCommand getCommand() {
        return this.command;
    }

    public String getPlayerCompanionUUID() {
        return this.playerCompanionUUID;
    }
}

