/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.network.message;

import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessagePlayerCompanionData {
    protected final CompoundTag data;
    protected final String playerCompanionUUID;

    public MessagePlayerCompanionData(String playerCompanionUUID, CompoundTag data) {
        this.playerCompanionUUID = playerCompanionUUID;
        this.data = data;
    }

    public static MessagePlayerCompanionData decode(FriendlyByteBuf buffer) {
        return new MessagePlayerCompanionData(buffer.m_130277_(), buffer.m_130260_());
    }

    public static void encode(MessagePlayerCompanionData message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.getPlayerCompanionUUID());
        buffer.m_130079_(message.getData());
    }

    public static void handle(MessagePlayerCompanionData message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MessagePlayerCompanionData.handlePacket(message)));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePlayerCompanionData message) {
        PlayerCompanionsClientData.load(message.getData());
    }

    public CompoundTag getData() {
        return this.data;
    }

    public String getPlayerCompanionUUID() {
        return this.playerCompanionUUID;
    }
}

