/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.network.message;

import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessagePlayerCompanionsData {
    protected final CompoundTag data;

    public MessagePlayerCompanionsData(CompoundTag data) {
        this.data = data;
    }

    public static MessagePlayerCompanionsData decode(FriendlyByteBuf buffer) {
        return new MessagePlayerCompanionsData(buffer.m_130260_());
    }

    public static void encode(MessagePlayerCompanionsData message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.getData());
    }

    public static void handle(MessagePlayerCompanionsData message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MessagePlayerCompanionsData.handlePacket(message)));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePlayerCompanionsData message) {
        PlayerCompanionsClientData.load(message.getData());
    }

    public CompoundTag getData() {
        return this.data;
    }
}

