/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.network.message;

import de.markusbordihn.playercompanions.Constants;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.skin.SkinType;
import de.markusbordihn.playercompanions.utils.PlayersUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageSkinChange {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected final UUID uuid;
    protected final String skin;
    protected final String skinURL;
    protected final UUID skinUUID;
    protected final SkinType skinType;

    public MessageSkinChange(UUID uuid, String skin, String skinURL, UUID skinUUID, SkinType skinType) {
        this.uuid = uuid;
        this.skin = skin;
        this.skinURL = skinURL;
        this.skinUUID = skinUUID;
        this.skinType = skinType;
    }

    public static MessageSkinChange decode(FriendlyByteBuf buffer) {
        return new MessageSkinChange(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130259_(), (SkinType)buffer.m_130066_(SkinType.class));
    }

    public static void encode(MessageSkinChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.skin);
        buffer.m_130070_(message.skinURL);
        buffer.m_130077_(message.skinUUID);
        buffer.m_130068_((Enum)message.getSkinType());
    }

    public static void handle(MessageSkinChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSkinChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSkinChange message, NetworkEvent.Context context) {
        SkinType skinType;
        ServerPlayer serverPlayer = context.getSender();
        if (serverPlayer == null) {
            log.error("Unable to get server player for message {} from {}", (Object)message, (Object)context);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)serverPlayer.m_9236_();
        UUID uuid = message.getUUID();
        String skin = message.getSkin();
        if (skin == null) {
            log.error("Invalid skin {} for {} from {}", (Object)skin, (Object)message, (Object)serverPlayer);
            return;
        }
        Entity entity = serverLevel.m_8791_(uuid);
        if (entity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            if (!serverPlayer.m_20148_().equals(playerCompanionEntity.m_21805_())) {
                log.error("Player {} tried to change skin {} ({}) for unowned {}", (Object)serverPlayer, (Object)skin, (Object)message.getSkin(), (Object)playerCompanionEntity);
                return;
            }
        }
        if ((skinType = message.getSkinType()) == null) {
            log.error("Invalid skin type {} for {} from {}", (Object)skinType, (Object)message, (Object)serverPlayer);
            return;
        }
        PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
        if (playerCompanionEntity == null) {
            log.error("Unable to get player companion entity for {} from {}", (Object)message, (Object)serverPlayer);
            return;
        }
        String skinURL = message.getSkinURL();
        UUID skinUUID = message.getSkinUUID();
        log.debug("Processing skin:{} uuid:{} url:{} type:{} model:{} for {} from {}", (Object)skin, (Object)skinUUID, (Object)skinURL, (Object)skinType, (Object)playerCompanionEntity.getSkinModel(), (Object)playerCompanionEntity, (Object)serverPlayer);
        switch (skinType) {
            case PLAYER_SKIN: {
                playerCompanionEntity.setSkinType(skinType);
                playerCompanionEntity.setSkinURL(skinURL != null && !skinURL.isBlank() ? skinURL : "");
                if (skinUUID != null && !Constants.BLANK_UUID.equals(skinUUID)) {
                    playerCompanionEntity.setSkinUUID(skinUUID);
                    break;
                }
                UUID userUUID = PlayersUtils.getUserUUID(serverPlayer.m_20194_(), skin);
                if (!skin.equals(userUUID.toString())) {
                    log.debug("Converted user {} to UUID {} ...", (Object)skin, (Object)userUUID);
                }
                playerCompanionEntity.setSkinUUID(userUUID);
                break;
            }
            case INSECURE_REMOTE_URL: 
            case SECURE_REMOTE_URL: {
                playerCompanionEntity.setSkinType(skinType);
                playerCompanionEntity.setSkinURL(skinURL != null && !skinURL.isBlank() ? skinURL : skin);
                playerCompanionEntity.setSkinUUID(skinUUID != null && !Constants.BLANK_UUID.equals(skinUUID) ? skinUUID : UUID.nameUUIDFromBytes(skin.getBytes()));
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)skin, (Object)skinUUID, (Object)skinURL, (Object)skinType, (Object)playerCompanionEntity, (Object)serverPlayer);
            }
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSkin() {
        return this.skin;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public UUID getSkinUUID() {
        return this.skinUUID;
    }

    public SkinType getSkinType() {
        return this.skinType;
    }
}

