/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayersUtils {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String USER_REGEX = "^\\w{2,16}$";
    private static final String TEXTURES_STRING = "textures";
    private static UUID lastUserUUIDForUserTexture;

    protected PlayersUtils() {
    }

    public static Optional<GameProfile> getGameProfile(MinecraftServer server, Component component) {
        return PlayersUtils.getGameProfile(server, component.getString());
    }

    public static Optional<GameProfile> getGameProfile(MinecraftServer server, String username) {
        if (server == null || username == null || username.isEmpty()) {
            return Optional.empty();
        }
        GameProfileCache gameProfileCache = server.m_129927_();
        return gameProfileCache != null ? gameProfileCache.m_10996_(username) : Optional.empty();
    }

    public static UUID getUserUUID(MinecraftServer server, String username) {
        String userUUID;
        UUID uuid = PlayersUtils.getUUIDfromString(username);
        if (uuid != null) {
            return uuid;
        }
        Optional<GameProfile> gameProfile = PlayersUtils.getGameProfile(server, username);
        if (gameProfile.isPresent() && gameProfile.get() != null && gameProfile.get().getId() != null && (userUUID = gameProfile.get().getId().toString()) != null && !userUUID.isEmpty()) {
            return PlayersUtils.getUUIDfromString(userUUID);
        }
        return null;
    }

    public static UUID getUUIDfromString(String uuidString) {
        try {
            UUID uuid = UUID.fromString(uuidString);
            if (uuid != null) {
                return uuid;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static String getUserTexture(UUID userUUID) {
        if (lastUserUUIDForUserTexture != null && lastUserUUIDForUserTexture.equals(userUUID)) {
            log.error("Ignore duplicated user texture request for {}!", (Object)userUUID);
            return null;
        }
        lastUserUUIDForUserTexture = userUUID;
        String sessionURL = String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s", userUUID);
        try {
            String data = IOUtils.toString((URL)new URL(sessionURL), (Charset)StandardCharsets.UTF_8);
            if (data == null || data.isEmpty()) {
                log.error("Unable to get user texture with {}", (Object)sessionURL);
                return null;
            }
            return PlayersUtils.getUserTextureFromSessionResponse(data);
        }
        catch (IOException ioException) {
            log.error("Unable to get user texture with {}, because of: {}", (Object)sessionURL, (Object)ioException);
            return null;
        }
    }

    public static String getUserTextureFromSessionResponse(String data) {
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        if (jsonObject != null && jsonObject.has("properties")) {
            JsonArray properties = jsonObject.getAsJsonArray("properties");
            log.debug("getUserTextureFromSessionRequest: {}", (Object)properties);
            for (JsonElement property : properties) {
                JsonObject propertyObject = property.getAsJsonObject();
                if (!propertyObject.has("name") || !TEXTURES_STRING.equals(propertyObject.get("name").getAsString()) || !propertyObject.has("value")) continue;
                String textureData = new String(Base64.getDecoder().decode(propertyObject.get("value").getAsString()));
                String userTexture = PlayersUtils.getUserTextureFromTextureData(textureData);
                String userTextureModel = PlayersUtils.getUserTextureModelFromTextureData(textureData);
                log.debug("Found user texture {} with model {} ...", (Object)userTexture, (Object)userTextureModel);
                return userTexture;
            }
        }
        return "";
    }

    public static String getUserTextureFromTextureData(String data) {
        JsonObject skinObject;
        JsonObject textureObject;
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        log.debug("getUserTextureFromTextureData: {}", (Object)jsonObject);
        if (jsonObject != null && jsonObject.has(TEXTURES_STRING) && (textureObject = jsonObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("url")) {
            return skinObject.get("url").getAsString();
        }
        return "";
    }

    public static String getUserTextureModelFromTextureData(String data) {
        JsonObject metaDataObject;
        JsonObject skinObject;
        JsonObject textureObject;
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        log.debug("getUserTextureFromTextureData: {}", (Object)jsonObject);
        if (jsonObject != null && jsonObject.has(TEXTURES_STRING) && (textureObject = jsonObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("metadata") && (metaDataObject = skinObject.getAsJsonObject("metadata")).has("model")) {
            return metaDataObject.get("model").getAsString();
        }
        return "";
    }

    public static JsonObject getJsonObject(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                return jsonElement.getAsJsonObject();
            }
        }
        catch (JsonParseException jsonParseException) {
            log.error("ERROR: Unable to parse json data: {}", (Object)data);
        }
        return null;
    }

    public static boolean isValidPlayerName(String name) {
        return name != null && !name.isEmpty() && !name.startsWith("http") && !name.equals("htt") && name.length() >= 3 && name.length() <= 16 && name.matches(USER_REGEX);
    }

    public static boolean isValidUrl(String url) {
        if (url == null || url.isEmpty() || !url.startsWith("http://") && !url.startsWith("https://")) {
            return false;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
        return true;
    }
}

