/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.utils;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.playercompanions.PlayerCompanions;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StopModReposts {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String STOP_MOD_REPOSTS_URL = "https://stopmodreposts.org/";
    private static final Optional<String> version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
    private static final boolean isDevEnvironment = version.isPresent() && version.get() != null && "MOD_DEV".equals(version.get());
    private static final String modFileFormatRegEx = "player_companions_1.20.1-\\d+.\\d+.\\d+.jar";
    private static final Pattern expectedFilePattern = Pattern.compile("player_companions_1.20.1-\\d+.\\d+.\\d+.jar");

    protected StopModReposts() {
    }

    public static void checkStopModReposts() {
        if (isDevEnvironment) {
            log.debug("Detected MDK environment, will skip Stop Mod Reposts checks.");
            return;
        }
        String jarFilePath = null;
        try {
            jarFilePath = PlayerCompanions.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (NullPointerException | SecurityException | URISyntaxException exception) {
            log.error("Unable to get jar file path: {}", (Throwable)exception);
        }
        if (jarFilePath == null || jarFilePath.isEmpty()) {
            log.debug("Received empty jar file path!");
            return;
        }
        if (expectedFilePattern.matcher(jarFilePath).find()) {
            log.info("Thanks for using {} ({}). I hope you enjoy the mod. :)", (Object)"Bo's Player Companions", (Object)"https://www.curseforge.com/minecraft/mc-mods/player-companions");
        } else {
            log.error("");
            log.error("===============================================");
            log.error("=                                             =");
            log.error("=   WARNING: File modification detected !!!   =");
            log.error("=                                             =");
            log.error("===============================================");
            log.error("");
            log.error("It's seems that the mod file you are using was modified!");
            log.error("Please make sure to download the latest {} mod only from the original source at {}", (Object)"Bo's Player Companions", (Object)"https://www.curseforge.com/minecraft/mc-mods/player-companions");
            log.error("If you downloaded this mod from other sources we could not make sure that it works as expected or does not includes any unwanted modification (e.g. adware, malware, ...).");
            log.error("");
            log.error("See the following page for more details: {}", (Object)STOP_MOD_REPOSTS_URL);
            log.error("");
        }
    }
}

