/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.supporters;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class SupportersJSON {
    private static Thread backgroundThread;
    private static SupportersJSON instance;
    private final Set<UUID> supporters = new HashSet<UUID>();
    private final Set<UUID> friends = new HashSet<UUID>();

    public static SupportersJSON get() {
        if (instance == null) {
            instance = new SupportersJSON();
        }
        return instance;
    }

    private SupportersJSON() {
    }

    public boolean isSupporter(UUID uuid) {
        return this.supporters.contains(uuid) || this.friends.contains(uuid);
    }

    public static void populateSupportersList() {
        if (backgroundThread != null && backgroundThread.isAlive()) {
            return;
        }
        backgroundThread = new SupporterJSONPopulatorThread();
        backgroundThread.start();
    }

    private static class SupporterJSONPopulatorThread
    extends Thread {
        public SupporterJSONPopulatorThread() {
            super("Ribbits Supporter JSON Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            File tempFile;
            InputStream resourceStream;
            try {
                resourceStream = this.fetchDataFromGitHub();
            }
            catch (IOException e) {
                RibbitsCommon.LOGGER.error("Unable to load Ribbits supporters.json resource!");
                RibbitsCommon.LOGGER.error((Object)e);
                return;
            }
            try {
                tempFile = File.createTempFile("resource-", ".tmp");
                tempFile.deleteOnExit();
                Files.copy(resourceStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                RibbitsCommon.LOGGER.error("Failed to create temp file for supporters.json", (Throwable)e);
                return;
            }
            if (!tempFile.exists()) {
                RibbitsCommon.LOGGER.error("Ribbits supporters.json temp file does not exist!");
                return;
            }
            if (!tempFile.canRead()) {
                RibbitsCommon.LOGGER.error("Ribbits supporters.json temp file is not readable!");
                return;
            }
            try {
                instance = (SupportersJSON)JSON.loadObjectFromJsonFile((Path)tempFile.toPath(), SupportersJSON.class);
                RibbitsCommon.LOGGER.info("Successfully loaded supporters.json file!");
            }
            catch (IOException e) {
                RibbitsCommon.LOGGER.error("Unable to load from supporters.json file: {}", (Object)e.getMessage());
            }
        }

        @NotNull
        private InputStream fetchDataFromGitHub() throws IOException {
            URL url = new URL("https://raw.githubusercontent.com/yungnickyoung/Ribbits/refs/heads/1.20.1/supporters.json");
            URLConnection conn = url.openConnection();
            int TIMEOUT = 10000;
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            return conn.getInputStream();
        }
    }
}

