/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.ukelele;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukelele.UkuleleNoteButton;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UkuleleNoteButtonRenderer
extends NoteButtonRenderer {
    protected final ResourceLocation topColumnNotePressedLocation = this.getResourceFromRoot("note/top_pressed.png");
    protected final ResourceLocation topColumnNoteReleasedLocation = this.getResourceFromRoot("note/top_released.png");
    protected final ResourceLocation topColumnNoteHoverLocation = this.getResourceFromRoot("note/top_hovered.png");

    public UkuleleNoteButtonRenderer(NoteButton noteButton, Supplier<ResourceLocation> labelTextureProvider) {
        super(noteButton, labelTextureProvider);
    }

    private UkuleleNoteButton getButton() {
        return (UkuleleNoteButton)this.noteButton;
    }

    @Override
    protected ResourceLocation getNoteReleasedLocation() {
        return this.getTopColumnOverride(this.topColumnNoteReleasedLocation, super.getNoteReleasedLocation());
    }

    @Override
    protected ResourceLocation getNotePressedLocation() {
        return this.getTopColumnOverride(this.topColumnNotePressedLocation, super.getNotePressedLocation());
    }

    @Override
    protected ResourceLocation getNoteHoverLocation() {
        return this.getTopColumnOverride(this.topColumnNoteHoverLocation, super.getNoteHoverLocation());
    }

    private ResourceLocation getTopColumnOverride(ResourceLocation newLocation, ResourceLocation superLocation) {
        if (this.getButton().ukuleleScreen().isTopRegular()) {
            return superLocation;
        }
        if (this.getButton().column == 0) {
            return newLocation;
        }
        return superLocation;
    }

    @Override
    protected void renderNote(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        if (this.getButton().ukuleleScreen().isTopRegular()) {
            super.renderNote(gui, themeLoader);
            return;
        }
        if (this.getButton().column != 0) {
            super.renderNote(gui, themeLoader);
            return;
        }
        int noteWidth = this.noteButton.m_5711_();
        int noteHeight = this.noteButton.m_93694_();
        int noteX = this.noteButton.m_252754_();
        int noteY = this.noteButton.m_252907_();
        float scaleMultiplier = (float)this.noteButton.m_5711_() / ((float)this.noteButton.instrumentScreen.getNoteSize() / 2.0f);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(scaleMultiplier, scaleMultiplier, scaleMultiplier);
        gui.m_280137_(UkuleleNoteButtonRenderer.MINECRAFT.f_91062_, this.getButton().getChordNameOfRow(), (int)(((float)noteX + (float)noteWidth / 2.0f) / scaleMultiplier), (int)(((float)noteY + (float)noteHeight / 4.0f + 2.0f) / scaleMultiplier), (this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.labelPressed(this.noteButton) : themeLoader.labelReleased(this.noteButton)).getRGB());
        gui.m_280168_().m_85849_();
    }
}

