/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.INoteLabel;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.MidiOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.LabelUtil;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class InstrumentOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final MutableComponent MIDI_OPTIONS = Component.m_237115_((String)"label.genshinstrument.midiOptions");
    private static final String SOUND_CHANNEL_KEY = "button.genshinstrument.audioChannels";
    private static final String STOP_MUSIC_KEY = "button.genshinstrument.stop_music_on_play";
    @Nullable
    protected final INoteLabel[] labels = this.getLabels();
    @Nullable
    protected INoteLabel currLabel;

    public abstract INoteLabel[] getLabels();

    public abstract INoteLabel getCurrentLabel();

    public boolean isPitchSliderEnabled() {
        return true;
    }

    public InstrumentOptionsScreen(@Nullable InstrumentScreen screen) {
        super((Component)Component.m_237115_((String)"button.genshinstrument.instrumentOptions"), screen);
    }

    public InstrumentOptionsScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"button.genshinstrument.instrumentOptions"), lastScreen);
    }

    protected void m_7856_() {
        this.currLabel = this.getCurrentLabel();
        GridLayout grid = ClientUtil.createSettingsGrid();
        this.initOptionsGrid(grid, grid.m_264606_(2));
        grid.m_264036_();
        ClientUtil.alignGrid((Layout)grid, this.f_96543_, this.f_96544_);
        grid.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        int buttonsY = ClientUtil.lowerButtonsY(grid.m_252907_(), grid.m_93694_(), this.f_96544_);
        int buttonsWidth = 150;
        Button doneBtn = Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.m_7379_()).m_252780_(150).m_253136_();
        if (!this.isOverlay || ((InstrumentScreen)((Object)this.instrumentScreen.get())).isMidiInstrument()) {
            LinearLayout buttonLayout = new LinearLayout(grid.m_252754_() + this.getSmallButtonWidth() - 150 + 4, buttonsY, 308, this.getButtonHeight(), LinearLayout.Orientation.HORIZONTAL);
            Button midiOptions = Button.m_253074_((Component)MIDI_OPTIONS.m_6881_().m_130946_("..."), btn -> this.openMidiOptions()).m_252780_(150).m_253136_();
            buttonLayout.m_264406_((LayoutElement)midiOptions);
            buttonLayout.m_264406_((LayoutElement)doneBtn);
            buttonLayout.m_264036_();
            buttonLayout.m_264134_(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
            });
        } else {
            doneBtn.m_264152_((this.f_96543_ - doneBtn.m_5711_()) / 2, buttonsY);
            this.m_142416_((GuiEventListener)doneBtn);
        }
    }

    protected void initAudioSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton instrumentChannel = CycleButton.m_168894_(soundType -> Component.m_237115_((String)("button.genshinstrument.audioChannels." + soundType.getKey()))).m_168961_((Object[])InstrumentChannelType.values()).m_168948_((Object)((InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get()))).m_232498_(soundType -> Tooltip.m_257550_((Component)(switch (soundType) {
            case InstrumentChannelType.MIXED -> InstrumentOptionsScreen.translatableArgs("button.genshinstrument.audioChannels.mixed.tooltip", 5.5);
            case InstrumentChannelType.STEREO -> Component.m_237115_((String)"button.genshinstrument.audioChannels.stereo.tooltip");
            default -> CommonComponents.f_237098_;
        }))).m_168936_(0, 0, this.getBigButtonWidth(), 20, (Component)Component.m_237115_((String)SOUND_CHANNEL_KEY), this::onChannelTypeChanged);
        rowHelper.m_264108_((LayoutElement)instrumentChannel, 2);
        if (this.isPitchSliderEnabled()) {
            SliderButton pitchSlider = new SliderButton(this.getSmallButtonWidth(), this.getPitch(), NoteSound.MIN_PITCH, NoteSound.MAX_PITCH){
                private static final DecimalFormat D_FORMAT = new DecimalFormat("0.00");
                private int pitch;
                {
                    this.pitch = InstrumentOptionsScreen.this.getPitch();
                }

                @Override
                public Component m_6035_() {
                    return Component.m_237115_((String)"button.genshinstrument.pitch").m_130946_(": " + LabelUtil.formatNoteName(LabelUtil.getNoteName(this.pitch, GridInstrumentScreen.NOTE_LAYOUT, 0), false) + " (" + D_FORMAT.format(NoteSound.getPitchByNoteOffset(this.pitch)) + ")");
                }

                protected void m_5697_() {
                    this.pitch = (int)this.getValueClamped();
                    InstrumentOptionsScreen.this.onPitchChanged(this, this.pitch);
                }
            };
            rowHelper.m_264139_((LayoutElement)pitchSlider);
        }
        SliderButton volumeSlider = new SliderButton(this.getSmallButtonWidth(), this.getVolume(), 0.0, 1.0){

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.volume").m_130946_(": " + (int)(this.f_93577_ * 100.0) + "%");
            }

            protected void m_5697_() {
                InstrumentOptionsScreen.this.onVolumeChanged(this, this.f_93577_);
            }
        };
        rowHelper.m_264139_((LayoutElement)volumeSlider);
    }

    protected void initVisualsSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton stopMusic = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237110_((String)"button.genshinstrument.stop_music_on_play.tooltip", (Object[])new Object[]{10.0}))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)STOP_MUSIC_KEY), this::onMusicStopChanged);
        rowHelper.m_264139_((LayoutElement)stopMusic);
        CycleButton sharedInstrument = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"button.genshinstrument.shared_instrument.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.shared_instrument"), this::onSharedInstrumentChanged);
        rowHelper.m_264139_((LayoutElement)sharedInstrument);
        CycleButton accurateNotes = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.ACCURATE_NOTES.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"button.genshinstrument.accurate_notes.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.accurate_notes"), this::onAccurateNotesChanged);
        rowHelper.m_264139_((LayoutElement)accurateNotes);
        if (this.labels != null) {
            CycleButton labelType = CycleButton.m_168894_(label -> Component.m_237115_((String)label.getKey())).m_168961_((Object[])this.labels).m_168948_((Object)this.currLabel).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)(value.getKey() + ".description")))).m_168936_(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.label"), this::onLabelChanged);
            rowHelper.m_264108_((LayoutElement)labelType, 2);
        }
    }

    protected void initOptionsGrid(GridLayout grid, GridLayout.RowHelper rowHelper) {
        this.initAudioSection(grid, rowHelper);
        rowHelper.m_264108_((LayoutElement)SpacerElement.m_264252_((int)7), 2);
        this.initVisualsSection(grid, rowHelper);
    }

    private int getPitch() {
        return this.instrumentScreen.map(InstrumentScreen::getPitch).orElseGet((Supplier<Integer>)ModClientConfigs.PITCH);
    }

    private double getVolume() {
        return this.instrumentScreen.map(screen -> screen.volume()).orElseGet((Supplier<Double>)ModClientConfigs.VOLUME);
    }

    protected void onPitchChanged(AbstractSliderButton slider, int pitch) {
        this.instrumentScreen.ifPresentOrElse(screen -> {
            if (screen.getPitch() == pitch) {
                return;
            }
            screen.setPitch(pitch);
            this.savePitch(pitch);
        }, () -> this.queueToSave("pitch", () -> this.savePitch(pitch)));
    }

    protected void savePitch(int newPitch) {
        ModClientConfigs.PITCH.set((Object)newPitch);
    }

    protected void onVolumeChanged(AbstractSliderButton slider, double volume) {
        int newVolume = (int)(volume * 100.0);
        this.instrumentScreen.ifPresent(screen -> {
            screen.volume = newVolume;
        });
        this.queueToSave("volume", () -> this.saveVolume((double)newVolume / 100.0));
    }

    protected void saveVolume(double newVolume) {
        ModClientConfigs.VOLUME.set((Object)CommonUtil.round(newVolume, 4));
    }

    protected void onLabelChanged(CycleButton<INoteLabel> button, INoteLabel label) {
        this.instrumentScreen.ifPresent(screen -> screen.setLabelSupplier(label.getLabelSupplier()));
        this.saveLabel(label);
    }

    protected abstract void saveLabel(INoteLabel var1);

    protected void onChannelTypeChanged(CycleButton<InstrumentChannelType> button, InstrumentChannelType type) {
        ModClientConfigs.CHANNEL_TYPE.set((Object)type);
    }

    protected void onMusicStopChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.STOP_MUSIC_ON_PLAY.set((Object)value);
    }

    protected void onSharedInstrumentChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.SHARED_INSTRUMENT.set((Object)value);
    }

    protected void onAccurateNotesChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.ACCURATE_NOTES.set((Object)value);
        this.instrumentScreen.ifPresent(screen -> screen.notesIterable().forEach(NoteButton::updateNoteLabel));
    }

    protected void openMidiOptions() {
        if (this.isOverlay) {
            this.f_96541_.popGuiLayer();
            this.f_96541_.pushGuiLayer((Screen)this.midiOptionsScreen());
        } else {
            this.f_96541_.m_91152_((Screen)this.midiOptionsScreen());
        }
    }

    protected MidiOptionsScreen midiOptionsScreen() {
        return new MidiOptionsScreen((Component)MIDI_OPTIONS, (Screen)this, this.instrumentScreen);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.instrumentScreen.ifPresent(InstrumentScreen::onOptionsClose);
    }

    private static MutableComponent translatableArgs(String key, Object arg) {
        return Component.m_237113_((String)Component.m_237115_((String)key).getString().replace("%s", arg.toString()));
    }
}

