/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.midi;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.IHoldableNoteButton;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.midi.MidiOverflowResult;
import com.cstav.genshinstrument.client.midi.PressedMIDINote;
import com.cstav.genshinstrument.event.MidiEvent;
import com.cstav.genshinstrument.sound.NoteSound;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class InstrumentMidiReceiver {
    public static final int MIN_MIDI_VELOCITY = 6;
    public final InstrumentScreen instrument;
    private final Map<Byte, PressedMIDINote> pressedMidiNotes = new HashMap<Byte, PressedMIDINote>();

    public InstrumentMidiReceiver(InstrumentScreen instrument) {
        this.instrument = instrument;
        MidiController.loadByConfigs();
    }

    @Nullable
    protected abstract NoteButton handleMidiPress(int var1, int var2);

    protected NoteButton getLowestNote() {
        throw new NotImplementedException("Overflow instrument does not implement getLowestNote");
    }

    protected NoteButton getHighestNote() {
        throw new NotImplementedException("Overflow instrument does not implement getHighestNote");
    }

    public void onMidi(MidiEvent event) {
        if (!this.canPerformMidi(event)) {
            return;
        }
        byte[] message = event.message.getMessage();
        byte midiNote = message[1];
        int note = this.getLowC(midiNote);
        if (this.isMIDIOutOfBounds(note)) {
            return;
        }
        float prevVolume = this.instrument.volume();
        this.handleDynamicTouch(message[2]);
        this.instrument.resetTransposition();
        boolean pitch = false;
        MidiOverflowResult overflowRes = this.handleMidiOverflow(note);
        if (overflowRes != null) {
            note = overflowRes.fixedOctaveNote();
            int newInsPitch = overflowRes.pitchOffset() + this.instrument.getPitch();
            if (newInsPitch < NoteSound.MIN_PITCH || newInsPitch > NoteSound.MIN_PITCH) {
                if (!((Integer)ModClientConfigs.PITCH.get()).equals(0)) {
                    ModClientConfigs.PITCH.set((Object)0);
                }
                this.instrument.setPitch(0);
            }
        }
        int basePitch = this.instrument.getPitch();
        NoteButton pressedNote = this.handleMidiPress(note, 0);
        if (pressedNote != null) {
            pressedNote.unlockInput();
            PressedMIDINote pressedMidiNote = this.playNote(pressedNote, overflowRes, basePitch);
            if (pressedMidiNote != null) {
                this.pressedMidiNotes.put(midiNote, pressedMidiNote);
            }
        }
        this.instrument.setVolume(prevVolume);
    }

    protected PressedMIDINote playNote(NoteButton noteBtn, @Nullable MidiOverflowResult midiOverflow, int basePitch) {
        if (midiOverflow == null) {
            noteBtn.play();
            return new PressedMIDINote(noteBtn.getPitch(), noteBtn, noteBtn.getSound());
        }
        int newPitch = basePitch + midiOverflow.pitchOffset();
        noteBtn.play(midiOverflow.newNoteSound(), newPitch);
        return new PressedMIDINote(newPitch, noteBtn, midiOverflow.newNoteSound());
    }

    protected boolean canPerformMidi(MidiEvent event) {
        byte[] message = event.message.getMessage();
        if (message.length != 3) {
            return false;
        }
        PressedMIDINote prevNoteBtn = this.pressedMidiNotes.get(message[1]);
        NoteButton prevButton = null;
        boolean isHoldableBtn = false;
        if (prevNoteBtn != null) {
            prevButton = prevNoteBtn.pressedNote();
            isHoldableBtn = prevButton instanceof IHoldableNoteButton;
            if (!isHoldableBtn) {
                prevButton.release();
            }
            this.pressedMidiNotes.remove(message[1]);
        }
        int eventType = message[0] >> 4 << 4;
        int midiChannel = message[0] - eventType;
        if (eventType == -112 && message[2] != 0) {
            if (!((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get()).booleanValue()) {
                return midiChannel == (Integer)ModClientConfigs.MIDI_CHANNEL.get();
            }
            return true;
        }
        if ((eventType == -128 || eventType == -112) && isHoldableBtn) {
            IHoldableNoteButton heldBtn = (IHoldableNoteButton)((Object)prevButton);
            heldBtn.releaseHeld(prevNoteBtn.notePitch(), true, heldBtn.toHeldSound(prevNoteBtn.sound()));
        }
        return false;
    }

    protected void handleDynamicTouch(int velocity) {
        float sensitivity = ((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get()).floatValue();
        if (!((Boolean)ModClientConfigs.FIXED_TOUCH.get()).booleanValue() && sensitivity != 0.0f) {
            double volMultiplier = (double)velocity / 127.0 / (double)sensitivity;
            this.instrument.volume = (int)Mth.m_14008_((double)((double)this.instrument.volume * volMultiplier), (double)6.0, (double)100.0);
        }
    }

    protected boolean shouldSharpen(int layoutNote, int key) {
        boolean shouldSharpen;
        boolean higherThan3 = layoutNote > key + 4;
        boolean bl = shouldSharpen = layoutNote % 2 != key % 2;
        if (higherThan3) {
            boolean bl2 = shouldSharpen = !shouldSharpen;
        }
        if (layoutNote < key) {
            shouldSharpen = !shouldSharpen;
        }
        return shouldSharpen;
    }

    protected boolean shouldFlatten(boolean shouldSharpen) {
        return shouldSharpen && this.instrument.getPitch() == NoteSound.MAX_PITCH;
    }

    protected void transposeMidi(boolean shouldSharpen, boolean shouldFlatten) {
        if (shouldFlatten) {
            this.instrument.transposeDown();
        } else if (shouldSharpen) {
            this.instrument.transposeUp();
        }
    }

    protected boolean isMIDIOutOfBounds(int note) {
        int minNote = this.canMidiOverflow() ? this.minMidiOverflow() : this.minMidiNote();
        int maxNote = this.canMidiOverflow() ? this.maxMidiOverflow() : this.maxMidiNote();
        return note < minNote || note >= maxNote;
    }

    protected boolean canMidiOverflow() {
        return this.allowMidiOverflow() && (Boolean)ModClientConfigs.EXTEND_OCTAVES.get() != false;
    }

    @Nullable
    protected MidiOverflowResult handleMidiOverflow(int note) {
        if (!this.canMidiOverflow()) {
            return null;
        }
        if (note < this.minMidiNote()) {
            return new MidiOverflowResult(this.getLowestNote().getSound(), note - this.minMidiNote(), note + 12, MidiOverflowResult.OverflowType.BOTTOM);
        }
        if (note >= this.maxMidiNote()) {
            return new MidiOverflowResult(this.getHighestNote().getSound(), note - this.maxMidiNote() + 1, note - 12, MidiOverflowResult.OverflowType.TOP);
        }
        return null;
    }

    protected int minMidiNote() {
        return 0;
    }

    protected abstract int maxMidiNote();

    public boolean allowMidiOverflow() {
        return false;
    }

    protected int maxMidiOverflow() {
        return this.maxMidiNote() + 12;
    }

    protected int minMidiOverflow() {
        return this.minMidiNote() - 12;
    }

    protected int getLowC(int note) {
        return note - (Integer)ModClientConfigs.OCTAVE_SHIFT.get() * 12 - 48;
    }
}

