/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.util;

import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import com.cstav.genshinstrument.networking.packet.instrument.util.S2CNotePacketDelegate;
import com.cstav.genshinstrument.sound.NoteSound;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class NoteSoundPacketUtil {
    private static final S2CNotePacketDelegate<NoteSound, S2CNoteSoundPacket> INIT = S2CNoteSoundPacket::new;

    public static void sendPlayerPlayNotePackets(Entity initiator, NoteSound sound, ResourceLocation instrumentId, int pitch, int volume) {
        NoteSoundPacketUtil.firePlayerEvent(initiator, InstrumentPacketUtil.sendPlayerPlayNotePackets(initiator, sound, instrumentId, pitch, volume, INIT));
    }

    public static void sendPlayerPlayNotePackets(Entity initiator, NoteSound sound, NoteSoundMetadata soundMeta) {
        NoteSoundPacketUtil.firePlayerEvent(initiator, InstrumentPacketUtil.sendPlayerPlayNotePackets(initiator, sound, soundMeta, INIT));
    }

    public static void sendPlayNotePackets(Level level, BlockPos pos, NoteSound sound, ResourceLocation instrumentId, int pitch, int volume) {
        NoteSoundPacketUtil.fireGenericEvent(level, InstrumentPacketUtil.sendPlayNotePackets(level, pos, sound, instrumentId, pitch, volume, INIT));
    }

    public static void sendPlayNotePackets(Level level, NoteSound sound, NoteSoundMetadata soundMeta) {
        NoteSoundPacketUtil.fireGenericEvent(level, InstrumentPacketUtil.sendPlayNotePackets(level, sound, soundMeta, INIT));
    }

    private static void firePlayerEvent(Entity initiator, S2CNoteSoundPacket packet) {
        MinecraftForge.EVENT_BUS.post((Event)new NoteSoundPlayedEvent(initiator, (NoteSound)packet.sound, packet.meta));
    }

    private static void fireGenericEvent(Level level, S2CNoteSoundPacket packet) {
        MinecraftForge.EVENT_BUS.post((Event)new NoteSoundPlayedEvent(level, (NoteSound)packet.sound, packet.meta));
    }
}

