/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

public class ServerUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerModPackets(SimpleChannel sc, List<Class<IModPacket>> acceptablePackets, Supplier<Integer> id) {
        for (Class<IModPacket> packetType : acceptablePackets) {
            NetworkDirection netDirection;
            try {
                netDirection = ServerUtil.getDirection(packetType);
            }
            catch (Exception e) {
                LOGGER.error("Error registering packet of type " + packetType.getName() + ". Make sure to have a NETWORK_DIRECTION static field of type NetworkDirection.", (Throwable)e);
                continue;
            }
            Constructor<IModPacket> packetConstructor = CommonUtil.getExpectedConstructor(packetType, FriendlyByteBuf.class);
            sc.registerMessage(id.get().intValue(), packetType, IModPacket::write, buf -> {
                try {
                    return (IModPacket)packetConstructor.newInstance(buf);
                }
                catch (Exception e) {
                    LOGGER.error("Error constructing packet of type {}", (Object)packetType.getName(), (Object)e);
                    return null;
                }
            }, (msg, contextSup) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSup.get();
                context.enqueueWork(() -> msg.handle(context));
                context.setPacketHandled(true);
            }, Optional.of(netDirection));
        }
    }

    private static NetworkDirection getDirection(Class<IModPacket> packetType) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return (NetworkDirection)packetType.getField("NETWORK_DIRECTION").get(null);
    }
}

