/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.content.item;

import com.dannbrown.deltaboxlib.content.entity.boat.BaseBoatEntity;
import com.dannbrown.deltaboxlib.content.entity.boat.BaseChestBoatEntity;
import com.dannbrown.deltaboxlib.content.item.BoatItem;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/dannbrown/deltaboxlib/content/item/BoatItem;", "Lnet/minecraft/world/item/Item;", "", "_name", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/vehicle/Boat;", "entityType", "", "hasChest", "Lnet/minecraft/world/item/Item$Properties;", "pProperties", "<init>", "(Ljava/lang/String;Ljava/util/function/Supplier;ZLnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/phys/HitResult;", "hitResult", "getBoat", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/HitResult;)Lnet/minecraft/world/entity/vehicle/Boat;", "pLevel", "Lnet/minecraft/world/entity/player/Player;", "pPlayer", "Lnet/minecraft/world/InteractionHand;", "pHand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Ljava/lang/String;", "Ljava/util/function/Supplier;", "Z", "Companion", "deltaboxlib-2.1.1-common-1.20.1"})
public final class BoatItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String _name;
    @NotNull
    private final Supplier<EntityType<? extends Boat>> entityType;
    private final boolean hasChest;
    @NotNull
    private static final Predicate<Entity> ENTITY_PREDICATE;

    public BoatItem(@NotNull String _name, @NotNull Supplier<EntityType<? extends Boat>> entityType, boolean hasChest, @NotNull Item.Properties pProperties) {
        Intrinsics.checkNotNullParameter((Object)_name, (String)"_name");
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)pProperties, (String)"pProperties");
        super(pProperties);
        this._name = _name;
        this.entityType = entityType;
        this.hasChest = hasChest;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack itemstack = itemStack;
        BlockHitResult blockHitResult = Item.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"getPlayerPOVHitResult(...)");
        HitResult hitresult = (HitResult)blockHitResult;
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemstack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getViewVector(...)");
        Vec3 vec32 = vec3;
        List list = pLevel.m_6249_((Entity)pPlayer, pPlayer.m_20191_().m_82369_(vec32.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        List list2 = list;
        if (!list2.isEmpty()) {
            Vec3 vec33 = pPlayer.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getEyePosition(...)");
            Vec3 vec31 = vec33;
            for (Entity entity : list2) {
                AABB aabb;
                Intrinsics.checkNotNullExpressionValue((Object)entity.m_20191_().m_82400_((double)entity.m_6143_()), (String)"inflate(...)");
                if (!aabb.m_82390_(vec31)) continue;
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemstack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(pLevel, hitresult);
            if (boat instanceof BaseChestBoatEntity) {
                ((BaseChestBoatEntity)boat).setVariant(this._name);
            } else if (boat instanceof BaseBoatEntity) {
                ((BaseBoatEntity)boat).setVariant(this._name);
            }
            boat.m_146922_(pPlayer.m_146908_());
            if (!pLevel.m_45756_((Entity)boat, boat.m_20191_())) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19100_((Object)itemstack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            if (!pLevel.f_46443_) {
                pLevel.m_7967_((Entity)boat);
                pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, hitresult.m_82450_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemstack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    private final Boat getBoat(Level level, HitResult hitResult) {
        return this.hasChest ? (Boat)new BaseChestBoatEntity(() -> BoatItem.getBoat$lambda$0(this), this._name, this.entityType, level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_) : (Boat)new BaseBoatEntity(() -> BoatItem.getBoat$lambda$1(this), this._name, this.entityType, level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
    }

    private static final Item getBoat$lambda$0(BoatItem this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0;
    }

    private static final Item getBoat$lambda$1(BoatItem this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0;
    }

    private static final boolean ENTITY_PREDICATE$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Predicate<Object> predicate = EntitySelector.f_20408_.and(arg_0 -> BoatItem.ENTITY_PREDICATE$lambda$2(Companion.ENTITY_PREDICATE.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"and(...)");
        ENTITY_PREDICATE = predicate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/dannbrown/deltaboxlib/content/item/BoatItem$Companion;", "", "<init>", "()V", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "ENTITY_PREDICATE", "Ljava/util/function/Predicate;", "deltaboxlib-2.1.1-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

