/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.forge.registrate;

import com.dannbrown.deltaboxlib.content.item.DeltaboxSpawnEggItem;
import com.dannbrown.deltaboxlib.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.registrate.builders.BlockBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.BlockEntityBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.EntityTypeBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.ItemBuilder;
import com.dannbrown.deltaboxlib.registrate.helpers.StripHelper;
import com.dannbrown.deltaboxlib.registrate.registry.ParticleRegistry;
import com.dannbrown.deltaboxlib.registrate.util.AttributesUtil;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.BadAttributeValueExpException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000f\u001a\u00020\u0006\"\b\b\u0000\u0010\n*\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\bJ\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010\u001dJ\u000f\u0010$\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b$\u0010\bJ\u000f\u0010%\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b%\u0010\bJ\u000f\u0010&\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b&\u0010\bJ\u000f\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b'\u0010\bJ\u000f\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\bJ\r\u0010)\u001a\u00020\u0006\u00a2\u0006\u0004\b)\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lcom/dannbrown/deltaboxlib/forge/registrate/RegistrateInitForge;", "", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "registrate", "<init>", "(Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;)V", "", "clientSetup", "()V", "Lnet/minecraft/core/particles/ParticleOptions;", "T", "Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;", "event", "Lcom/dannbrown/deltaboxlib/registrate/registry/ParticleRegistry$ParticleRegistration;", "registration", "handleParticleRegistration", "(Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;Lcom/dannbrown/deltaboxlib/registrate/registry/ParticleRegistry$ParticleRegistration;)V", "init", "Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Block;", "onRegisterBlockBiomeColors", "(Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Block;)V", "Lnet/minecraftforge/event/entity/EntityAttributeCreationEvent;", "onRegisterEntityAttributes", "(Lnet/minecraftforge/event/entity/EntityAttributeCreationEvent;)V", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterRenderers;", "onRegisterEntityRenderers", "(Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterRenderers;)V", "Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Item;", "onRegisterItemBiomeColors", "(Lnet/minecraftforge/client/event/RegisterColorHandlersEvent$Item;)V", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;", "onRegisterLayerDefinitions", "(Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;)V", "onRegisterParticleRenders", "(Lnet/minecraftforge/client/event/RegisterParticleProvidersEvent;)V", "onRegisterSpawnEggColors", "registerComposterBlocks", "registerDispenserBehaviors", "registerPottedBlocks", "registerStrippableBlocks", "registerWoodTypes", "setup", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "getRegistrate", "()Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "deltaboxlib-2.1.1-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRegistrateInitForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistrateInitForge.kt\ncom/dannbrown/deltaboxlib/forge/registrate/RegistrateInitForge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,213:1\n1855#2,2:214\n1855#2,2:218\n766#2:220\n857#2,2:221\n1549#2:223\n1620#2,3:224\n766#2:229\n857#2,2:230\n1549#2:232\n1620#2,3:233\n215#3,2:216\n37#4,2:227\n37#4,2:236\n*S KotlinDebug\n*F\n+ 1 RegistrateInitForge.kt\ncom/dannbrown/deltaboxlib/forge/registrate/RegistrateInitForge\n*L\n101#1:214,2\n139#1:218,2\n195#1:220\n195#1:221,2\n195#1:223\n195#1:224,3\n207#1:229\n207#1:230,2\n207#1:232\n207#1:233,3\n108#1:216,2\n202#1:227,2\n211#1:236,2\n*E\n"})
public final class RegistrateInitForge {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;

    public RegistrateInitForge(@NotNull AbstractDeltaboxRegistrate registrate) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        this.registrate = registrate;
    }

    @NotNull
    public final AbstractDeltaboxRegistrate getRegistrate() {
        return this.registrate;
    }

    public final void init() {
    }

    public final void setup() {
        this.registerStrippableBlocks();
        this.registerPottedBlocks();
        this.registerComposterBlocks();
        this.registerDispenserBehaviors();
    }

    public final void clientSetup() {
        this.registerWoodTypes();
    }

    private final void registerStrippableBlocks() {
        for (BlockBuilder<? extends Block> block : this.registrate.getBlockRegistry().getEntries()) {
            Supplier<Block> other;
            if (block.getContext().getStrippableOther() == null) continue;
            if (!other.get().m_49966_().m_61138_((Property)BlockStateProperties.f_61365_)) {
                throw new BadAttributeValueExpException((Object)"Output stripped block should have 'axis' property!");
            }
            if (!block.getBlock().get().m_49966_().m_61138_((Property)BlockStateProperties.f_61365_)) {
                throw new BadAttributeValueExpException((Object)"Input stripped block should have 'axis' property!");
            }
            StripHelper.INSTANCE.registerStrippable(block.getBlock().get(), other.get());
        }
    }

    private final void registerPottedBlocks() {
        for (BlockBuilder<? extends Block> block : this.registrate.getBlockRegistry().getEntries()) {
            Supplier<Block> plant = block.getContext().getPottedOther();
            if (plant == null) continue;
            try {
                Block block2 = Blocks.f_50276_;
                Intrinsics.checkNotNull((Object)block2, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.FlowerPotBlock");
                ((FlowerPotBlock)block2).addPlant(DeltaboxUtil.INSTANCE.resourceLocation(DeltaboxUtil.INSTANCE.getBlockModId(plant.get()), DeltaboxUtil.INSTANCE.getBlockId(plant.get())), block.getBlock());
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add plant " + plant.get().m_49954_() + " to flower pot " + block.getBlock().get().m_49954_()));
            }
        }
    }

    private final void registerComposterBlocks() {
        float amount;
        for (BlockBuilder<? extends Block> blockBuilder : this.registrate.getBlockRegistry().getEntries()) {
            amount = blockBuilder.getContext().getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                ComposterBlock.f_51914_.put((Object)blockBuilder.getBlock().get().m_5456_(), amount);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add block " + blockBuilder.getBlock().get().m_49954_() + " to compostables"));
            }
        }
        for (ItemBuilder itemBuilder : this.registrate.getItemRegistry().getEntries()) {
            amount = itemBuilder.getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                ComposterBlock.f_51914_.put(itemBuilder.getItem().get(), amount);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add block " + ((Item)itemBuilder.getItem().get()).m_5524_() + " to compostables"));
            }
        }
    }

    private final void registerDispenserBehaviors() {
        Object element$iv;
        Object $this$forEach$iv = DeltaboxSpawnEggItem.Companion.getMOD_EGGS();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            DeltaboxSpawnEggItem egg = (DeltaboxSpawnEggItem)((Object)element$iv);
            boolean bl = false;
            DispenseItemBehavior behavior = egg.createDispenseBehavior();
            boolean bl2 = false;
            DispenserBlock.m_52672_((ItemLike)((ItemLike)egg), (DispenseItemBehavior)behavior);
            DeltaboxSpawnEggItem.Companion.getTYPE_MAP().put(egg.getTypeSupplier().get(), egg);
        }
        $this$forEach$iv = this.registrate.getDispenserBehaviorRegistry().getRegistries();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Supplier t = (Supplier)object.getKey();
            DispenseItemBehavior u = (DispenseItemBehavior)object.getValue();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)t.get()), (DispenseItemBehavior)u);
        }
    }

    private final void registerWoodTypes() {
        for (Map.Entry<String, WoodType> entry : this.registrate.getWoodTypesRegistry().getAllWoodTypes().entrySet()) {
            String key = entry.getKey();
            WoodType woodType = entry.getValue();
            Sheets.addWoodType((WoodType)woodType);
        }
    }

    public final void onRegisterEntityRenderers(@NotNull EntityRenderersEvent.RegisterRenderers event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (EntityTypeBuilder<? extends Entity> entityTypeBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityTypeBuilder.getEntityRenderer() == null) continue;
            event.registerEntityRenderer(entityTypeBuilder.getEntity().get(), entityTypeBuilder::getRenderer);
        }
        for (BlockEntityBuilder blockEntityBuilder : this.registrate.getBlockEntityRegistry().getEntries()) {
            if (blockEntityBuilder.getBlockEntityRenderer() == null) continue;
            event.registerBlockEntityRenderer(blockEntityBuilder.getBlockEntity().get(), blockEntityBuilder::getRenderer);
        }
    }

    public final void onRegisterSpawnEggColors(@NotNull RegisterColorHandlersEvent.Item event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = DeltaboxSpawnEggItem.Companion.getMOD_EGGS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeltaboxSpawnEggItem egg = (DeltaboxSpawnEggItem)((Object)element$iv);
            boolean bl = false;
            ItemColors itemColors = event.getItemColors();
            ItemColor itemColor = (arg_0, arg_1) -> RegistrateInitForge.onRegisterSpawnEggColors$lambda$4$lambda$3(egg, arg_0, arg_1);
            ItemLike[] itemLikeArray = new ItemLike[1];
            Intrinsics.checkNotNull((Object)((Object)egg), (String)"null cannot be cast to non-null type net.minecraft.world.level.ItemLike");
            itemLikeArray[0] = egg;
            itemColors.m_92689_(itemColor, itemLikeArray);
        }
    }

    public final void onRegisterParticleRenders(@NotNull RegisterParticleProvidersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (ParticleRegistry.ParticleRegistration<? extends ParticleOptions> particle : this.registrate.getParticleRegistry().getParticles()) {
            this.handleParticleRegistration(event, particle);
        }
    }

    public final void onRegisterLayerDefinitions(@NotNull EntityRenderersEvent.RegisterLayerDefinitions event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (String entry : this.registrate.getBoatVariantRegistry().getBoatVariants()) {
            event.registerLayerDefinition(new ModelLayerLocation(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "boat/" + entry), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "chest_boat/" + entry), "main"), ChestBoatModel::m_247175_);
        }
        for (Map.Entry entry : this.registrate.getModelLayersRegistry().getModelLayers().entrySet()) {
            String path = (String)entry.getKey();
            Pair data = (Pair)entry.getValue();
            Supplier model = (Supplier)data.component1();
            Supplier modelLayer = (Supplier)data.component2();
            event.registerLayerDefinition((ModelLayerLocation)modelLayer.get(), model);
        }
    }

    public final void onRegisterEntityAttributes(@NotNull EntityAttributeCreationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (EntityTypeBuilder<? extends Entity> entityBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityBuilder.getAttributeBuilderFactory() == null) continue;
            try {
                EntityType<? extends Entity> entityType = entityBuilder.getEntity().get();
                Intrinsics.checkNotNull(entityType, (String)"null cannot be cast to non-null type net.minecraft.world.entity.EntityType<out net.minecraft.world.entity.LivingEntity>");
                Function<AttributesUtil, AttributeSupplier.Builder> function = entityBuilder.getAttributeBuilderFactory();
                Intrinsics.checkNotNull(function);
                event.put(entityType, function.apply(AttributesUtil.INSTANCE).m_22265_());
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to register entity " + entityBuilder.getEntityId() + " attributs, it may not be a living entity"));
            }
        }
    }

    private final <T extends ParticleOptions> void handleParticleRegistration(RegisterParticleProvidersEvent event, ParticleRegistry.ParticleRegistration<T> registration) {
        event.registerSpriteSet((ParticleType)registration.getType().get(), arg_0 -> RegistrateInitForge.handleParticleRegistration$lambda$5(registration.getProvider(), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void onRegisterBlockBiomeColors(@NotNull RegisterColorHandlersEvent.Block event) {
        void $this$mapTo$iv$iv;
        BlockBuilder it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$filter$iv = this.registrate.getBlockRegistry().getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BlockBuilder)element$iv$iv;
            boolean bl = false;
            if (!it.getContext().getHasBiomeColors()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BlockBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Block)it.getBlock().get());
        }
        List blocks = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = blocks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
        event.getBlockColors().m_92589_(RegistrateInitForge::onRegisterBlockBiomeColors$lambda$8, Arrays.copyOf(blockArray, blockArray.length));
    }

    /*
     * WARNING - void declaration
     */
    public final void onRegisterItemBiomeColors(@NotNull RegisterColorHandlersEvent.Item event) {
        void $this$mapTo$iv$iv;
        BlockBuilder it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$filter$iv = this.registrate.getBlockRegistry().getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BlockBuilder)element$iv$iv;
            boolean bl = false;
            if (!it.getContext().getHasBiomeColors()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BlockBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Block)it.getBlock().get());
        }
        List blocks = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = blocks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
        event.getItemColors().m_92689_((arg_0, arg_1) -> RegistrateInitForge.onRegisterItemBiomeColors$lambda$11(event, arg_0, arg_1), (ItemLike[])Arrays.copyOf(blockArray, blockArray.length));
    }

    private static final int onRegisterSpawnEggColors$lambda$4$lambda$3(DeltaboxSpawnEggItem $egg, ItemStack stack, int layer) {
        Intrinsics.checkNotNullParameter((Object)((Object)$egg), (String)"$egg");
        return $egg.m_43211_(layer);
    }

    private static final ParticleProvider handleParticleRegistration$lambda$5(Function1 $tmp0, SpriteSet arg) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ParticleProvider)$tmp0.invoke((Object)arg);
    }

    private static final int onRegisterBlockBiomeColors$lambda$8(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
        return level != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.m_46113_();
    }

    private static final int onRegisterItemBiomeColors$lambda$11(RegisterColorHandlersEvent.Item $event, ItemStack stack, int tintIndex) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Item item = stack.m_41720_();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
        BlockState state = ((BlockItem)item).m_40614_().m_49966_();
        return $event.getBlockColors().m_92577_(state, null, null, tintIndex);
    }
}

