/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.util;

import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\tJ)\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J9\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ9\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/util/AdvancementUtil;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "key", "Lnet/minecraft/network/chat/Component;", "advancementDescription", "(Ljava/lang/String;)Lnet/minecraft/network/chat/Component;", "advancementTitle", "Lnet/minecraft/world/item/Item;", "iconItem", "Lnet/minecraft/resources/ResourceLocation;", "background", "Lnet/minecraft/advancements/Advancement$Builder;", "basicAdvancement", "(Lnet/minecraft/world/item/Item;Ljava/lang/String;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/advancements/Advancement$Builder;", "builder", "savePath", "Lnet/minecraft/advancements/RequirementsStrategy;", "requirementsStrategy", "", "Lnet/minecraft/world/level/ItemLike;", "items", "Lnet/minecraft/advancements/Advancement;", "hasItemsCriterion", "(Lnet/minecraft/advancements/Advancement$Builder;Ljava/lang/String;Lnet/minecraft/advancements/RequirementsStrategy;[Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/advancements/Advancement;", "", "Lnet/minecraft/world/level/block/Block;", "itemOnBlock", "usedOnBlockCriterion", "(Lnet/minecraft/advancements/Advancement$Builder;Ljava/lang/String;Lnet/minecraft/advancements/RequirementsStrategy;Ljava/util/Map;)Lnet/minecraft/advancements/Advancement;", "Ljava/lang/String;", "getModId", "()Ljava/lang/String;", "deltaboxlib-2.1.1-common-1.20.1"})
public final class AdvancementUtil {
    @NotNull
    private final String modId;

    public AdvancementUtil(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.modId = modId;
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    @NotNull
    public final Component advancementTitle(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableComponent mutableComponent = Component.m_237115_((String)("advancements." + this.modId + "." + key + ".title"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final Component advancementDescription(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableComponent mutableComponent = Component.m_237115_((String)("advancements." + this.modId + "." + key + ".description"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final Advancement.Builder basicAdvancement(@NotNull Item iconItem, @NotNull String key, @Nullable ResourceLocation background) {
        Intrinsics.checkNotNullParameter((Object)iconItem, (String)"iconItem");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138358_(new DisplayInfo(new ItemStack((ItemLike)iconItem), this.advancementTitle(key), this.advancementDescription(key), background, FrameType.TASK, true, true, false));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"display(...)");
        return builder;
    }

    public static /* synthetic */ Advancement.Builder basicAdvancement$default(AdvancementUtil advancementUtil, Item item, String string, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 4) != 0) {
            resourceLocation = null;
        }
        return advancementUtil.basicAdvancement(item, string, resourceLocation);
    }

    @NotNull
    public final Advancement hasItemsCriterion(@NotNull Advancement.Builder builder, @NotNull String savePath, @NotNull RequirementsStrategy requirementsStrategy, ItemLike ... items) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter((Object)requirementsStrategy, (String)"requirementsStrategy");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        for (ItemLike item : items) {
            ItemPredicate[] itemPredicateArray = new ItemPredicate[1];
            ItemLike[] itemLikeArray = new ItemLike[]{item};
            itemPredicateArray[0] = ItemPredicate.Builder.m_45068_().m_151445_(itemLikeArray).m_45077_();
            builder.m_138386_("has_" + item.m_5456_().m_5524_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])itemPredicateArray));
        }
        Advancement advancement = builder.m_138360_(requirementsStrategy).m_138403_(DeltaboxUtil.INSTANCE.resourceLocation(this.modId, savePath));
        Intrinsics.checkNotNullExpressionValue((Object)advancement, (String)"build(...)");
        return advancement;
    }

    @NotNull
    public final Advancement usedOnBlockCriterion(@NotNull Advancement.Builder builder, @NotNull String savePath, @NotNull RequirementsStrategy requirementsStrategy, @NotNull Map<ItemLike, ? extends Block> itemOnBlock) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter((Object)requirementsStrategy, (String)"requirementsStrategy");
        Intrinsics.checkNotNullParameter(itemOnBlock, (String)"itemOnBlock");
        for (Map.Entry<ItemLike, ? extends Block> entry : itemOnBlock.entrySet()) {
            ItemLike item = entry.getKey();
            Block block = entry.getValue();
            Block[] blockArray = new Block[]{block};
            LocationPredicate.Builder builder2 = LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(blockArray).m_17931_());
            blockArray = new ItemLike[]{item};
            builder.m_138386_("used_" + DeltaboxUtil.INSTANCE.getItemId(item) + "_on_" + DeltaboxUtil.INSTANCE.getBlockId(block), (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_285945_((LocationPredicate.Builder)builder2, (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])blockArray)));
        }
        Advancement advancement = builder.m_138360_(requirementsStrategy).m_138403_(DeltaboxUtil.INSTANCE.resourceLocation(this.modId, savePath));
        Intrinsics.checkNotNullExpressionValue((Object)advancement, (String)"build(...)");
        return advancement;
    }
}

