/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.util;

import com.dannbrown.deltaboxlib.registrate.util.AbstractWorldgenUtil;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\nJM\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00170\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ#\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!J\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/util/PlacedFeaturesUtil;", "Lcom/dannbrown/deltaboxlib/registrate/util/AbstractWorldgenUtil;", "<init>", "()V", "", "pCount", "Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;", "pHeightRange", "", "commonOrePlacement", "(ILnet/minecraft/world/level/levelgen/placement/PlacementModifier;)Ljava/util/List;", "placementModifier", "modifier", "orePlacement", "(Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;)Ljava/util/List;", "pChance", "rareOrePlacement", "Lnet/minecraft/data/worldgen/BootstapContext;", "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;", "context", "Lnet/minecraft/resources/ResourceKey;", "key", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/feature/ConfiguredFeature;", "configuration", "modifiers", "", "register", "(Lnet/minecraft/data/worldgen/BootstapContext;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/Holder;Ljava/util/List;)V", "", "name", "modId", "registerKey", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/resources/ResourceKey;", "chance", "wildCropPlaced", "(I)Ljava/util/List;", "deltaboxlib-2.1.1-common-1.20.1"})
public final class PlacedFeaturesUtil
extends AbstractWorldgenUtil {
    @NotNull
    public static final PlacedFeaturesUtil INSTANCE = new PlacedFeaturesUtil();

    private PlacedFeaturesUtil() {
    }

    @NotNull
    public final ResourceKey<PlacedFeature> registerKey(@NotNull String name, @NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)DeltaboxUtil.INSTANCE.resourceLocation(modId, name));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        return resourceKey;
    }

    public final void register(@NotNull BootstapContext<PlacedFeature> context, @NotNull ResourceKey<PlacedFeature> key, @NotNull Holder<ConfiguredFeature<?, ?>> configuration, @NotNull List<? extends PlacementModifier> modifiers) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        context.m_255272_(key, (Object)new PlacedFeature(configuration, modifiers));
    }

    @NotNull
    public final List<PlacementModifier> orePlacement(@NotNull PlacementModifier placementModifier, @NotNull PlacementModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)placementModifier, (String)"placementModifier");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Object[] objectArray = new PlacementModifier[4];
        objectArray[0] = placementModifier;
        Intrinsics.checkNotNullExpressionValue((Object)InSquarePlacement.m_191715_(), (String)"spread(...)");
        objectArray[2] = modifier;
        Intrinsics.checkNotNullExpressionValue((Object)BiomeFilter.m_191561_(), (String)"biome(...)");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<PlacementModifier> commonOrePlacement(int pCount, @NotNull PlacementModifier pHeightRange) {
        Intrinsics.checkNotNullParameter((Object)pHeightRange, (String)"pHeightRange");
        CountPlacement countPlacement = CountPlacement.m_191628_((int)pCount);
        Intrinsics.checkNotNullExpressionValue((Object)countPlacement, (String)"of(...)");
        return this.orePlacement((PlacementModifier)countPlacement, pHeightRange);
    }

    @NotNull
    public final List<PlacementModifier> rareOrePlacement(int pChance, @NotNull PlacementModifier pHeightRange) {
        Intrinsics.checkNotNullParameter((Object)pHeightRange, (String)"pHeightRange");
        RarityFilter rarityFilter = RarityFilter.m_191900_((int)pChance);
        Intrinsics.checkNotNullExpressionValue((Object)rarityFilter, (String)"onAverageOnceEvery(...)");
        return this.orePlacement((PlacementModifier)rarityFilter, pHeightRange);
    }

    private final List<PlacementModifier> wildCropPlaced(int chance) {
        Object[] objectArray = new PlacementModifier[]{RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

