/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.MultiBlockPattern;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllPatterns;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BedBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class BedDoubleBlock
extends BedBlock {
    public BedDoubleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected int getBedFootMultiBlockIndex(BlockState blockState) {
        int index = this.getMultiBlockIndex(blockState);
        return index % 2 == 0 ? 2 : 3;
    }

    @Override
    public void onFixBedRotations(LivingEntity entity, PoseStack pose) {
        if (entity instanceof RemotePlayer) {
            pose.m_85841_(0.85f, 0.85f, 0.85f);
            pose.m_85837_(0.0, 0.2, 0.15);
        } else {
            pose.m_85841_(0.9f, 0.9f, 0.9f);
            pose.m_85837_(0.0, 0.2, -0.05);
        }
    }

    public MultiBlockPattern getMultiBlockPattern() {
        return AllPatterns.PATTERN_2x2x1;
    }

    public RenderShape m_7514_(BlockState blockState) {
        if (AllBlocks.DUNMER_BED_DOUBLE.isIn(blockState) && this.getMultiBlockIndex(blockState) == 2) {
            return RenderShape.MODEL;
        }
        return super.m_7514_(blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.NORDIC.bedDouble(this, blockState);
        }
        if (AllBlocks.DUNMER_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.DUNMER.bedDouble(this, blockState);
        }
        if (AllBlocks.VENTHYR_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.VENTHYR.bedDouble(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_BED_DOUBLE.isIn(blockState) || AllBlocks.BONE_WITHER_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.BONE.bedDouble(this, blockState);
        }
        if (AllBlocks.ROYAL_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.ROYAL.bedDouble(this, blockState);
        }
        if (AllBlocks.NECROLORD_BED_DOUBLE.isIn(blockState)) {
            return HitBoxes.NECROLORD.bedDouble(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends BedDoubleBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            return IDyeable.getDyedMapColor(blockState, level, pos, defaultColor);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        @Override
        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

