/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.gui.handler.slot.PalmBarOutputSlot;
import net.satisfy.beachparty.core.registry.ScreenHandlerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class MiniFridgeGuiHandler
extends AbstractContainerMenu {
    private final ContainerData propertyDelegate;

    public MiniFridgeGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public MiniFridgeGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerTypesRegistry.MINI_FRIDGE_GUI_HANDLER.get(), syncId);
        this.propertyDelegate = propertyDelegate;
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
        this.m_38884_(propertyDelegate);
    }

    public int getShakeXProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (totalProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 22 / totalProgress + 1;
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_(new PalmBarOutputSlot(playerInventory.f_35978_, inventory, 0, 116, 35));
        this.m_38897_(new Slot(inventory, 1, 56, 35));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        boolean outputSlot = false;
        boolean inputSlot = true;
        int playerInvStart = 2;
        int hotbarStart = 29;
        int hotbarEnd = 38;
        if (index == 0) {
            if (!this.m_38903_(stack, 2, 38, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, originalStack);
        } else if (index == 1 ? !this.m_38903_(stack, 2, 38, false) : index >= 2 && !this.m_38903_(stack, 1, 2, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

