/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import net.satisfy.beachparty.core.util.SandCastleManager;
import org.jetbrains.annotations.NotNull;

public class SandBucketBlock
extends HorizontalDirectionalBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> SandBucketBlock.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)12.0);
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public SandBucketBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Block emptySandBucketBlock = (Block)ObjectRegistry.SAND_BUCKET_BLOCK_EMPTY.get();
        Block sandBucketBlock = (Block)ObjectRegistry.SAND_BUCKET_BLOCK_FILLED.get();
        if (state.m_60734_() == emptySandBucketBlock && itemStack.m_41720_() == Items.f_41830_) {
            itemStack.m_41774_(1);
            world.m_46597_(pos, (BlockState)sandBucketBlock.m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_))));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        SandCastleManager.registerSandCastle(pos);
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        SandCastleManager.unregisterSandCastle(pos);
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public static class SandPileBlock
    extends SandBlock {
        private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

        public SandPileBlock(int color, BlockBehaviour.Properties settings) {
            super(color, settings);
        }

        @NotNull
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return SHAPE;
        }

        public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity && entity.m_6095_() != EntityType.f_20490_) {
                entity.m_7601_(state, new Vec3(0.8, 0.75, 0.8));
            }
        }
    }

    public static class SandCastleBlock
    extends Block {
        public static final BooleanProperty TALL_TOWER;
        public static final VoxelShape TALL_TOWER_SHAPE;
        public static final BooleanProperty RIGHT_TOWER;
        public static final VoxelShape RIGHT_TOWER_SHAPE;
        public static final BooleanProperty TOP_TOWER;
        public static final VoxelShape TOP_TOWER_SHAPE;
        public static final BooleanProperty LEFT_TOWER;
        public static final VoxelShape LEFT_TOWER_SHAPE;
        public static final BooleanProperty PETRIFIED;
        private static final VoxelShape BASE_SHAPE;

        public SandCastleBlock(BlockBehaviour.Properties settings) {
            super(settings.m_60977_());
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TALL_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PETRIFIED, (Comparable)Boolean.valueOf(false)));
        }

        @NotNull
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            VoxelShape shape = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[0]);
            if (((Boolean)state.m_61143_((Property)TALL_TOWER)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TALL_TOWER_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)RIGHT_TOWER)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RIGHT_TOWER_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)LEFT_TOWER)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEFT_TOWER_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)TOP_TOWER)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TOP_TOWER_SHAPE);
            }
            return shape;
        }

        @NotNull
        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            ItemStack handStack = player.m_21120_(hand);
            if (PotionUtils.m_43579_((ItemStack)handStack) == Potions.f_43599_ && !((Boolean)state.m_61143_((Property)PETRIFIED)).booleanValue()) {
                if (!player.m_150110_().f_35937_) {
                    handStack.m_41774_(1);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)PETRIFIED, (Comparable)Boolean.valueOf(true)));
                if (world.f_46443_) {
                    int i;
                    BlockState smoothSandState = Blocks.f_50471_.m_49966_();
                    for (i = 0; i < 8; ++i) {
                        world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, smoothSandState), (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                    for (i = 0; i < 6; ++i) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (handStack.m_41720_() == ObjectRegistry.SAND_BUCKET_FILLED.get() && !this.hasAllTowers(state)) {
                BooleanProperty tower = this.getTowerHitPos(hit);
                if (!((Boolean)state.m_61143_((Property)tower)).booleanValue()) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)tower, (Comparable)Boolean.valueOf(true)));
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_EMPTY.get()));
                    if (world.f_46443_) {
                        for (int i = 0; i < 8; ++i) {
                            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12334_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            } else if (handStack.m_41720_() == ObjectRegistry.SAND_BUCKET_EMPTY.get()) {
                if (this.hasNoTowers(state)) {
                    world.m_46961_(pos, false);
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.f_46443_) {
                        for (int i = 0; i < 6; ++i) {
                            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                BooleanProperty tower = this.getTowerHitPos(hit);
                if (((Boolean)state.m_61143_((Property)tower)).booleanValue()) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)tower, (Comparable)Boolean.valueOf(false)));
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.f_46443_) {
                        for (int i = 0; i < 6; ++i) {
                            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            return InteractionResult.PASS;
        }

        public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
            if (!((Boolean)state.m_61143_((Property)PETRIFIED)).booleanValue()) {
                world.m_46597_(pos, ((Block)ObjectRegistry.SAND_PILE.get()).m_49966_());
            } else if (entity.m_6095_() == EntityType.f_20501_) {
                world.m_46961_(pos, true);
            }
        }

        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
            if (!((Boolean)state.m_61143_((Property)PETRIFIED)).booleanValue() && (world.m_46758_(pos) || world.m_46758_(pos.m_7494_()))) {
                world.m_46597_(pos, ((Block)ObjectRegistry.SAND_PILE.get()).m_49966_());
                return;
            }
            if (!state.m_60710_((LevelReader)world, pos)) {
                world.m_46961_(pos, true);
            }
        }

        private void exchangeStack(ItemStack handStack, Player player, ItemStack possibleReturnStack) {
            ItemStack returnStack;
            ItemStack itemStack = returnStack = !player.m_150110_().f_35937_ ? possibleReturnStack : handStack;
            if (player.m_7500_()) {
                if (!player.m_150109_().m_36063_(returnStack)) {
                    player.m_150109_().m_36054_(returnStack);
                }
                return;
            }
            Inventory inventory = player.m_150109_();
            int slot = inventory.m_36030_(handStack);
            handStack.m_41774_(1);
            if (player.m_150109_().m_8020_(slot).m_41619_()) {
                if (!inventory.m_36040_(slot, returnStack)) {
                    player.m_36176_(returnStack, false);
                }
            } else if (!inventory.m_36054_(returnStack)) {
                player.m_36176_(returnStack, false);
            }
        }

        private BooleanProperty getTowerHitPos(BlockHitResult hitResult) {
            double x = hitResult.m_82450_().m_7096_();
            double z = hitResult.m_82450_().m_7094_();
            double relX = x - (double)hitResult.m_82425_().m_123341_();
            double relZ = z - (double)hitResult.m_82425_().m_123343_();
            if (relX >= 0.5 && relZ >= 0.5) {
                return TALL_TOWER;
            }
            if (relX < 0.5 && relZ >= 0.5) {
                return RIGHT_TOWER;
            }
            if (relX >= 0.5 && relZ < 0.5) {
                return LEFT_TOWER;
            }
            return TOP_TOWER;
        }

        private boolean hasAllTowers(BlockState state) {
            return (Boolean)state.m_61143_((Property)TALL_TOWER) != false && (Boolean)state.m_61143_((Property)RIGHT_TOWER) != false && (Boolean)state.m_61143_((Property)TOP_TOWER) != false && (Boolean)state.m_61143_((Property)LEFT_TOWER) != false;
        }

        private boolean hasNoTowers(BlockState state) {
            return (Boolean)state.m_61143_((Property)TALL_TOWER) == false && (Boolean)state.m_61143_((Property)RIGHT_TOWER) == false && (Boolean)state.m_61143_((Property)TOP_TOWER) == false && (Boolean)state.m_61143_((Property)LEFT_TOWER) == false;
        }

        @NotNull
        public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
            if (!state.m_60710_((LevelReader)world, pos)) {
                world.m_186460_(pos, (Block)this, 1);
            }
            return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            BlockPos blockPos = pos.m_7495_();
            return world.m_8055_(blockPos).m_60783_((BlockGetter)world, blockPos, Direction.UP);
        }

        @NotNull
        public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
            return new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get());
        }

        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return false;
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TALL_TOWER, RIGHT_TOWER, TOP_TOWER, LEFT_TOWER, PETRIFIED});
        }

        static {
            TALL_TOWER_SHAPE = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)15.0, (double)15.0);
            RIGHT_TOWER_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0);
            TOP_TOWER_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
            LEFT_TOWER_SHAPE = Block.m_49796_((double)11.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0);
            BASE_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));
            TALL_TOWER = BooleanProperty.m_61465_((String)"tall");
            RIGHT_TOWER = BooleanProperty.m_61465_((String)"right");
            TOP_TOWER = BooleanProperty.m_61465_((String)"top");
            LEFT_TOWER = BooleanProperty.m_61465_((String)"left");
            PETRIFIED = BooleanProperty.m_61465_((String)"petrified");
        }
    }
}

