/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.beachparty.core.block.SandBucketBlock;
import net.satisfy.beachparty.core.util.SandCastleManager;

public class ApproachSandCastleGoal
extends Goal {
    private final Mob mob;
    private BlockPos targetPos;
    private int cooldown;
    private int recalculateCooldown;
    private boolean isMoving;

    public ApproachSandCastleGoal(Mob mob) {
        this.mob = mob;
        this.cooldown = 0;
        this.recalculateCooldown = 0;
        this.isMoving = false;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 60;
        if (this.recalculateCooldown > 0) {
            --this.recalculateCooldown;
        } else {
            this.recalculateCooldown = 200;
            BlockPos mobPos = this.mob.m_20183_();
            BlockPos newTargetPos = SandCastleManager.getNearestSandCastle(mobPos);
            if (newTargetPos == null || newTargetPos.equals((Object)this.targetPos)) {
                return false;
            }
            this.targetPos = newTargetPos;
            this.isMoving = false;
        }
        return this.targetPos != null;
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            this.moveToTarget();
        }
    }

    private void moveToTarget() {
        this.mob.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 1.0);
        this.isMoving = true;
    }

    public boolean m_8045_() {
        if (this.targetPos == null) {
            return false;
        }
        Level level = this.mob.m_9236_();
        BlockState state = level.m_8055_(this.targetPos);
        if (!(state.m_60734_() instanceof SandBucketBlock.SandCastleBlock)) {
            return false;
        }
        double distanceSquared = this.mob.m_20275_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5);
        return distanceSquared <= 16.0;
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        Level level = this.mob.m_9236_();
        BlockState state = level.m_8055_(this.targetPos);
        if (!(state.m_60734_() instanceof SandBucketBlock.SandCastleBlock)) {
            this.m_8041_();
            return;
        }
        double distanceSquared = this.mob.m_20275_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5);
        if (distanceSquared > 2.25) {
            if (!this.isMoving) {
                this.moveToTarget();
            }
        } else {
            this.isMoving = false;
        }
    }

    public void m_8041_() {
        this.targetPos = null;
        this.isMoving = false;
    }
}

