/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.platform.PlatformHelper;
import org.joml.Vector3d;

public class MessageInABottleSpawner {
    private static BlockPos lastValidSpawn = null;
    private static long lastSpawnTime = 0L;

    private static void attemptSpawn(ServerLevel level, int maxCount) {
        int z;
        int x;
        BlockPos pos;
        if (level.m_6907_().isEmpty()) {
            return;
        }
        RandomSource random = level.f_46441_;
        ServerPlayer player = (ServerPlayer)level.m_6907_().get(random.m_188503_(level.m_6907_().size()));
        if (lastValidSpawn == null || level.m_46467_() - lastSpawnTime > 12000L) {
            lastValidSpawn = MessageInABottleSpawner.findValidSpawnPos(level, player.m_20183_());
            lastSpawnTime = level.m_46467_();
        }
        if (lastValidSpawn == null) {
            return;
        }
        int spawnX = lastValidSpawn.m_123341_();
        int spawnY = lastValidSpawn.m_123342_();
        int spawnZ = lastValidSpawn.m_123343_();
        int count = 0;
        for (int i = 0; !(i >= 200 || level.m_46805_(pos = new BlockPos(x = spawnX - 50 + random.m_188503_(101), spawnY, z = spawnZ - 50 + random.m_188503_(101))) && level.m_8055_(pos).m_60734_() == ObjectRegistry.MESSAGE_IN_A_BOTTLE.get() && ++count >= maxCount); ++i) {
        }
        if (count >= maxCount) {
            return;
        }
        BlockState state = ((Block)ObjectRegistry.MESSAGE_IN_A_BOTTLE.get()).m_49966_();
        Vector3d vec = new Vector3d((double)lastValidSpawn.m_123341_() + 0.5, (double)lastValidSpawn.m_123342_(), (double)lastValidSpawn.m_123343_() + 0.5);
        BlockPos placePos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
        if (!level.m_46805_(placePos)) {
            return;
        }
        if (level.m_46859_(placePos) && level.m_8055_(placePos.m_7495_()).m_204336_(BlockTags.f_13029_)) {
            level.m_7731_(placePos, state, 3);
        }
    }

    private static BlockPos findValidSpawnPos(ServerLevel level, BlockPos center) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 10; ++i) {
            int offsetZ;
            int offsetX = random.m_188503_(200) - 100;
            BlockPos newPos = center.m_7918_(offsetX, 0, offsetZ = random.m_188503_(200) - 100);
            Holder biome = level.m_204166_(newPos);
            if (!biome.m_203656_(BiomeTags.f_207604_)) continue;
            int spawnY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, newPos.m_123341_(), newPos.m_123343_()) - 2;
            return new BlockPos(newPos.m_123341_(), spawnY, newPos.m_123343_());
        }
        return null;
    }

    public static void tick(ServerLevel level) {
        if (!PlatformHelper.allowBottleSpawning()) {
            return;
        }
        int interval = PlatformHelper.getBottleSpawnInterval();
        int maxCount = PlatformHelper.getBottleMaxCount();
        if (level.m_46467_() % (long)interval == 0L) {
            MessageInABottleSpawner.attemptSpawn(level, maxCount);
        }
    }
}

