/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.satisfy.beachparty.Beachparty;
import net.satisfy.beachparty.core.block.BeachSunLounger;
import net.satisfy.beachparty.core.block.BeachTowelBlock;
import net.satisfy.beachparty.core.registry.CompostablesRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.forge.client.integration.CuriosWearableTrinket;
import net.satisfy.beachparty.forge.registry.BeachpartyConfig;
import net.satisfy.beachparty.forge.registry.BeachpartyVillagers;
import net.satisfy.beachparty.platform.forge.PlatformHelperImpl;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod(value="beachparty")
public class BeachpartyForge {
    public BeachpartyForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus((String)"beachparty", (IEventBus)modEventBus);
        BeachpartyVillagers.register(modEventBus);
        PlatformHelperImpl.ENTITY_TYPES.register(modEventBus);
        BeachpartyConfig.loadConfig(BeachpartyConfig.COMMON_CONFIG, Platform.getConfigFolder().resolve("beachparty.toml").toString());
        Beachparty.init();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::enqueueIMC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CompostablesRegistry::init);
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.BEACH_HAT.get()), (ICurioItem)new CuriosWearableTrinket.BaseCurio(new Item[0]));
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.SUNGLASSES.get()), (ICurioItem)new CuriosWearableTrinket.BaseCurio(new Item[0]));
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.SWIM_WINGS.get()), (ICurioItem)new CuriosWearableTrinket.SwimWingsCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.BIKINI.get()), (ICurioItem)new CuriosWearableTrinket.SwimSuitCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.TRUNKS.get()), (ICurioItem)new CuriosWearableTrinket.SwimSuitCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_BLUE.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_PINK.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_PELICAN.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.CROCS.get()), (ICurioItem)new CuriosWearableTrinket.CrocsCurio());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("feet").size(1).icon(new ResourceLocation("minecraft", "item/empty_armor_slot_boots")).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HANDS.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60734_() == ObjectRegistry.RADIO.get()) {
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="beachparty", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventsHandler {
        @SubscribeEvent
        public static void playerSetSpawn(PlayerSetSpawnEvent event) {
            Level level = event.getEntity().m_9236_();
            if (event.getNewSpawn() != null) {
                Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
                if (!level.f_46443_ && (block instanceof BeachTowelBlock || block instanceof BeachSunLounger) && !event.isForced()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

