/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom;

import java.util.List;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.button.AbstractWallButton;
import net.larsmans.infinitybuttons.sounds.InfinityButtonsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DoorbellButton
extends AbstractWallButton {
    protected static final VoxelShape NORTH_PRESSED_SHAPE = Block.m_49796_((double)6.0, (double)4.0, (double)14.0, (double)10.0, (double)12.0, (double)16.0);
    protected static final VoxelShape EAST_PRESSED_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)2.0, (double)12.0, (double)10.0);
    protected static final VoxelShape SOUTH_PRESSED_SHAPE = Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)12.0, (double)2.0);
    protected static final VoxelShape WEST_PRESSED_SHAPE = Block.m_49796_((double)14.0, (double)4.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)NORTH_PRESSED_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)6.0, (double)13.0, (double)9.0, (double)10.0, (double)14.0));
    protected static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)EAST_PRESSED_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)7.0, (double)3.0, (double)10.0, (double)9.0));
    protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)SOUTH_PRESSED_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0, (double)3.0));
    protected static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)WEST_PRESSED_SHAPE, (VoxelShape)Block.m_49796_((double)13.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0, (double)9.0));

    public DoorbellButton(BlockBehaviour.Properties properties) {
        super(properties, NORTH_SHAPE, EAST_SHAPE, SOUTH_SHAPE, WEST_SHAPE, NORTH_PRESSED_SHAPE, EAST_PRESSED_SHAPE, SOUTH_PRESSED_SHAPE, WEST_PRESSED_SHAPE);
    }

    @Override
    public int getPressDuration() {
        return 15;
    }

    @Override
    protected void playSound(@Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_5594_((Player)(pressed ? playerIn : null), pos, this.getSoundEvent(pressed), SoundSource.BLOCKS, 0.3f, 1.0f);
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return (SoundEvent)InfinityButtonsSounds.DOORBELL.get();
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbors(state, (Level)worldIn, pos);
            worldIn.m_142346_(null, GameEvent.f_223703_, pos);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "doorbell_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

