/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractHorizontalButton
extends HorizontalDirectionalBlock {
    public static final BooleanProperty PRESSED = BooleanProperty.m_61465_((String)"pressed");
    public final VoxelShape NORTH_SHAPE;
    public final VoxelShape EAST_SHAPE;
    public final VoxelShape SOUTH_SHAPE;
    public final VoxelShape WEST_SHAPE;
    public final VoxelShape NORTH_PRESSED_SHAPE;
    public final VoxelShape EAST_PRESSED_SHAPE;
    public final VoxelShape SOUTH_PRESSED_SHAPE;
    public final VoxelShape WEST_PRESSED_SHAPE;

    protected AbstractHorizontalButton(BlockBehaviour.Properties properties, VoxelShape north_shape, VoxelShape east_shape, VoxelShape south_shape, VoxelShape west_shape, VoxelShape north_pressed_shape, VoxelShape east_pressed_shape, VoxelShape south_pressed_shape, VoxelShape west_pressed_shape) {
        super(properties);
        this.NORTH_SHAPE = north_shape;
        this.EAST_SHAPE = east_shape;
        this.SOUTH_SHAPE = south_shape;
        this.WEST_SHAPE = west_shape;
        this.NORTH_PRESSED_SHAPE = north_pressed_shape;
        this.EAST_PRESSED_SHAPE = east_pressed_shape;
        this.SOUTH_PRESSED_SHAPE = south_pressed_shape;
        this.WEST_PRESSED_SHAPE = west_pressed_shape;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean bl = (Boolean)state.m_61143_((Property)PRESSED);
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return bl ? this.NORTH_PRESSED_SHAPE : this.NORTH_SHAPE;
            }
            case EAST: {
                return bl ? this.EAST_PRESSED_SHAPE : this.EAST_SHAPE;
            }
            case SOUTH: {
                return bl ? this.SOUTH_PRESSED_SHAPE : this.SOUTH_SHAPE;
            }
        }
        return bl ? this.WEST_PRESSED_SHAPE : this.WEST_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PRESSED, f_54117_});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.powerBlock(state, worldIn, pos);
        this.playSound(player, (LevelAccessor)worldIn, pos, true);
        worldIn.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void powerBlock(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(state, world, pos);
        world.m_186460_(pos, (Block)this, this.getPressDuration());
    }

    public abstract int getPressDuration();

    protected void playSound(@Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_247517_((Player)(pressed ? playerIn : null), pos, this.getSoundEvent(pressed), SoundSource.BLOCKS);
    }

    protected abstract SoundEvent getSoundEvent(boolean var1);

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (isMoving || state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            this.updateNeighbors(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false && blockState.m_61143_((Property)f_54117_) == side ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbors(state, (Level)worldIn, pos);
            this.playSound(null, (LevelAccessor)worldIn, pos, false);
            worldIn.m_142346_(null, GameEvent.f_223703_, pos);
        }
    }

    public void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()), (Block)this);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }
}

