/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.button;

import java.util.List;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.button.AbstractSmallButton;
import net.larsmans.infinitybuttons.block.custom.button.WeatheringButton;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StickyCopperButton
extends AbstractSmallButton {
    public StickyCopperButton(BlockBehaviour.Properties properties, boolean large) {
        super(false, large, properties);
    }

    @Override
    public int getPressDuration() {
        return 0;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(handIn);
        if (itemStack.m_41720_() instanceof AxeItem) {
            return WeatheringButton.getUnsticky(state).map(waxedBlockState -> {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, itemStack);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
                }
                worldIn.m_7731_(pos, (BlockState)waxedBlockState.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 11);
                worldIn.m_5898_(player, 3004, pos, 0);
                worldIn.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }).orElse(InteractionResult.PASS);
        }
        if (((Boolean)state.m_61143_((Property)PRESSED)).booleanValue()) {
            this.unpowerBlock(state, worldIn, pos);
            this.playSound(player, (LevelAccessor)worldIn, pos, false);
        } else {
            this.powerBlock(state, worldIn, pos);
            this.playSound(player, (LevelAccessor)worldIn, pos, true);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    @Override
    public void powerBlock(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(state, world, pos);
    }

    public void unpowerBlock(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)), 3);
        this.updateNeighbors(state, world, pos);
    }

    @Override
    protected void playSound(@javax.annotation.Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean hitByArrow) {
        worldIn.m_5594_((Player)(hitByArrow ? playerIn : null), pos, this.getSoundEvent(hitByArrow), SoundSource.BLOCKS, 1.0f, hitByArrow ? 0.6f : 0.5f);
    }

    @Override
    protected SoundEvent getSoundEvent(boolean isOn) {
        return SoundEvents.f_144117_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "sticky_copper_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

