/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.torch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.larsmans.infinitybuttons.block.custom.torch.TorchButton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WallTorchButton
extends TorchButton {
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallTorchButton(BlockBehaviour.Properties properties, ParticleOptions particleData, Block jadeBlock) {
        super(properties, particleData, jadeBlock);
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = worldIn.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)worldIn, blockPos, direction);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.m_122424_() == pState.m_61143_((Property)f_54117_) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return pState;
    }

    @Override
    public void updateNeighbors(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
        worldIn.m_46672_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()), (Block)this);
    }

    @Override
    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false && blockState.m_61143_((Property)f_54117_) == side ? 15 : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction = (Direction)stateIn.m_61143_((Property)f_54117_);
        if (((Boolean)stateIn.m_61143_((Property)PRESSED)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.6;
            double d2 = (double)pos.m_123343_() + 0.5;
            Direction direction2 = direction.m_122424_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.05 * (double)direction2.m_122429_(), d1 + 0.15, d2 + 0.05 * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
            worldIn.m_7106_(this.particle, d0 + 0.05 * (double)direction2.m_122429_(), d1 + 0.15, d2 + 0.05 * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
        } else {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + 0.7;
            double f = (double)pos.m_123343_() + 0.5;
            double g = 0.22;
            double h = 0.27;
            Direction direction2 = direction.m_122424_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + h * (double)direction2.m_122429_(), e + g, f + h * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
            worldIn.m_7106_(this.particle, d + h * (double)direction2.m_122429_(), e + g, f + h * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
        }
    }
}

