/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.network.packets;

import java.util.function.Supplier;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.larsmans.infinitybuttons.network.IBClientPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class AlarmPacket {
    private final BlockPos pos;
    private final AlarmEnum alarmEnum;

    public AlarmPacket(BlockPos pos, AlarmEnum alarmEnum) {
        this.pos = pos;
        this.alarmEnum = alarmEnum;
    }

    public static void encode(AlarmPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130068_((Enum)packet.alarmEnum);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public AlarmEnum getAlarmEnum() {
        return this.alarmEnum;
    }

    public static AlarmPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        AlarmEnum alarmEnum = (AlarmEnum)buffer.m_130066_(AlarmEnum.class);
        return new AlarmPacket(pos, alarmEnum);
    }

    public static void handle(AlarmPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> IBClientPacketHandler.handleAlarmPacket(packet)));
        context.setPacketHandled(true);
    }
}

