/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.network.packets;

import java.util.Objects;
import java.util.function.Supplier;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButton;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButtonEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class LetterButtonStatePacket {
    private final BlockPos pos;
    private final LetterButtonEnum buttonEnum;

    public LetterButtonStatePacket(BlockPos pos, LetterButtonEnum buttonEnum) {
        this.pos = pos;
        this.buttonEnum = buttonEnum;
    }

    public static void encode(LetterButtonStatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130068_((Enum)packet.buttonEnum);
    }

    public static LetterButtonStatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        LetterButtonEnum buttonEnum = (LetterButtonEnum)buffer.m_130066_(LetterButtonEnum.class);
        return new LetterButtonStatePacket(pos, buttonEnum);
    }

    public static void handle(LetterButtonStatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Level world = Objects.requireNonNull(context.getSender()).m_9236_();
            BlockPos pos = packet.pos;
            BlockState state = world.m_8055_(pos);
            LetterButtonEnum buttonEnum = packet.buttonEnum;
            if (state.m_60734_() instanceof LetterButton) {
                world.m_7731_(pos, (BlockState)state.m_61124_(LetterButton.CHARACTER, (Comparable)((Object)buttonEnum)), 3);
            }
        });
        context.setPacketHandled(true);
    }
}

