/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod;

import com.endlesnights.torchslabsmod.ITorchSlabCompat;
import com.endlesnights.torchslabsmod.blocks.vanilla.VanillaCompat;
import com.endlesnights.torchslabsmod.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="torchslabmod")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TorchSlabsMod {
    public static final String MODID = "torchslabmod";
    public static final String NAME = "Torch Slab Mod";
    private static final List<Supplier<ITorchSlabCompat>> compatList = new ArrayList<Supplier>(Arrays.asList(VanillaCompat::new));

    public TorchSlabsMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER, "torchslabmod-server.toml");
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("torchslabmod-server.toml").toString());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        for (Supplier<ITorchSlabCompat> compat : compatList) {
            compat.get().registerBlocks(bus);
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        for (Supplier<ITorchSlabCompat> compat : compatList) {
            compat.get().registerRenderTypes();
        }
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        for (Supplier<ITorchSlabCompat> compat : compatList) {
            compat.get().registerPlaceEntries();
        }
    }
}

