/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.vanilla;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockWallTorchSlab
extends WallTorchBlock {
    private static final Map<Direction, VoxelShape> SHAPES_BOTTOM = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private static final Map<Direction, VoxelShape> SHAPES_TOP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)11.0, (double)11.0, (double)10.5, (double)21.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)11.0, (double)0.0, (double)10.5, (double)21.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)11.0, (double)5.5, (double)16.0, (double)21.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)5.5, (double)5.0, (double)21.0, (double)10.5)));
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    final ParticleOptions FLAMEPART;
    final Character TYPE;

    public BlockWallTorchSlab(BlockBehaviour.Properties properties, ParticleOptions particleType, Character type) {
        super(properties, particleType);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_58119_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM));
        this.TYPE = type;
        this.FLAMEPART = particleType;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_58119_, HALF});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == Half.TOP) {
            return SHAPES_TOP.get(state.m_61143_((Property)f_58119_));
        }
        return SHAPES_BOTTOM.get(state.m_61143_((Property)f_58119_));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = ((Direction)state.m_61143_((Property)f_58119_)).m_122424_();
        if (state.m_61143_(HALF) == Half.BOTTOM && (worldIn.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof SlabBlock && worldIn.m_8055_(pos.m_121945_(direction)).m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM || worldIn.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof StairBlock && worldIn.m_8055_(pos.m_121945_(direction)).m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM || super.m_7898_(state, worldIn, pos))) {
            return true;
        }
        if (state.m_61143_(HALF) == Half.TOP && (worldIn.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof SlabBlock && worldIn.m_8055_(pos.m_121945_(direction)).m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || worldIn.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof StairBlock && worldIn.m_8055_(pos.m_121945_(direction)).m_61143_((Property)StairBlock.f_56842_) == Half.TOP || super.m_7898_(state, worldIn, pos))) {
            return BlockWallTorchSlab.validTop(worldIn.m_8055_(pos.m_7494_()), state);
        }
        return false;
    }

    public static boolean validTop(BlockState state, BlockState torchState) {
        return state.m_60734_() instanceof AirBlock || state.m_60734_() instanceof LiquidBlock || state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || state.m_60734_() instanceof StairBlock && state.m_61143_(HALF) == Half.TOP && state.m_61143_((Property)f_58119_) == torchState.m_61143_((Property)f_58119_) || state.m_60734_() instanceof EndRodBlock || state.m_60734_() instanceof TorchBlock || state.m_60734_() instanceof WallSignBlock || state.m_60734_() instanceof LadderBlock || state.m_60734_() instanceof WebBlock || state.m_60734_() instanceof VineBlock || state.m_60734_() instanceof RedstoneWallTorchBlock || state.m_60734_() instanceof ButtonBlock;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        Direction direction = (Direction)stateIn.m_61143_((Property)f_58119_);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.7;
        double d2 = (double)pos.m_123343_() + 0.5;
        if (stateIn.m_61143_(HALF) == Half.TOP) {
            d1 += 0.5;
        }
        Direction direction1 = direction.m_122424_();
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
        worldIn.m_7106_(this.FLAMEPART, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)(this.TYPE.charValue() == 't' ? Items.f_42000_ : Items.f_41852_));
    }
}

