/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerLanternSlab {
    private static final HashMap<ResourceLocation, Supplier<Block>> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)held.m_41720_());
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerLanternSlab.placeLantern(event, held, PLACE_ENTRIES.get(rl).get());
        }
    }

    private static void placeLantern(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.m_121945_(face);
        Level world = event.getLevel();
        if (world.m_8055_(pos).m_60734_() instanceof SlabBlock && (world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && face == Direction.UP || world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP && face == Direction.DOWN) && (world.m_46859_(placeAt) || world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_)) {
            if (block instanceof SimpleWaterloggedBlock) {
                world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(face == Direction.DOWN))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_)));
            } else {
                world.m_46597_(placeAt, (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(face == Direction.DOWN)));
            }
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Supplier<Block> torchSlabSupplier) {
        if (!PLACE_ENTRIES.containsKey(itemName) && torchSlabSupplier != null) {
            PLACE_ENTRIES.put(itemName, torchSlabSupplier);
        }
    }
}

