/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockWallTorchSlab;
import com.endlesnights.torchslabsmod.config.Config;
import com.endlesnights.torchslabsmod.config.TorchSlabConfig;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerLanternWall {
    private static final HashMap<ResourceLocation, Supplier<Block>> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)held.m_41720_());
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerLanternWall.placeLantern(event, held, PLACE_ENTRIES.get(rl).get());
        }
    }

    private static void placeLantern(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.m_121945_(face);
        Level world = event.getLevel();
        Player playerIn = event.getEntity();
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("torchslabmod-server.toml").toString());
        if (!((Boolean)TorchSlabConfig.wallLanternCheck.get()).booleanValue() || !playerIn.m_20161_() && ((List)TorchSlabConfig.interactiveCheckList.get()).contains(ForgeRegistries.BLOCKS.getKey((Object)world.m_8055_(pos).m_60734_()).toString())) {
            return;
        }
        if (face != Direction.UP && face != Direction.DOWN && Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)face) && (world.m_46859_(placeAt) || world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_)) {
            if (PlaceHandlerLanternWall.blockHalf(playerIn, pos, face) <= 0.0 && !Block.m_49863_((LevelReader)world, (BlockPos)placeAt.m_7495_(), (Direction)face.m_122424_()) && ((Boolean)TorchSlabConfig.lowerLanternCheck.get()).booleanValue()) {
                world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM));
            } else {
                world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
            }
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        } else if ((world.m_8055_(pos).m_60734_() instanceof SlabBlock && world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM || world.m_8055_(pos).m_60734_() instanceof StairBlock && world.m_8055_(pos).m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM || world.m_8055_(pos).m_60734_() instanceof FenceBlock && PlaceHandlerLanternWall.blockHalf(playerIn, pos, face) <= 0.0) && face != Direction.UP && face != Direction.DOWN && (world.m_46859_(placeAt) || world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_) && !Block.m_49863_((LevelReader)world, (BlockPos)placeAt.m_7495_(), (Direction)face.m_122424_())) {
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM));
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        } else if ((world.m_8055_(pos).m_60734_() instanceof SlabBlock && world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || world.m_8055_(pos).m_60734_() instanceof StairBlock && world.m_8055_(pos).m_61143_((Property)StairBlock.f_56842_) == Half.TOP || world.m_8055_(pos).m_60734_() instanceof FenceBlock && PlaceHandlerLanternWall.blockHalf(playerIn, pos, face) >= 0.0) && face != Direction.UP && face != Direction.DOWN && (world.m_46859_(placeAt) || world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_)) {
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    static double blockHalf(Player playerIn, BlockPos pos, Direction face) {
        double angleX = Math.toRadians(playerIn.m_146908_());
        double angleY = Math.toRadians(playerIn.m_146909_());
        double sinYaw = Math.sin(angleX);
        double cosYaw = Math.cos(angleX);
        double sinPitch = Math.sin(angleY);
        double cosPitch = Math.cos(angleY);
        Vec3 directionAngle = new Vec3(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
        Double yOffset = playerIn.m_20299_((float)1.0f).f_82480_ - ((double)pos.m_123342_() + 0.5);
        if (face == Direction.NORTH) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82481_ - (double)pos.m_123343_()) / directionAngle.f_82479_;
            return magnatude * directionAngle.f_82480_ + yOffset;
        }
        if (face == Direction.SOUTH) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82481_ - (double)(pos.m_123343_() + 1)) / directionAngle.f_82479_;
            return magnatude * directionAngle.f_82480_ + yOffset;
        }
        if (face == Direction.WEST) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82479_ - (double)pos.m_123341_()) / -directionAngle.f_82481_;
            return magnatude * directionAngle.f_82480_ + yOffset;
        }
        if (face == Direction.EAST) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82479_ - (double)(pos.m_123341_() + 1)) / -directionAngle.f_82481_;
            return magnatude * directionAngle.f_82480_ + yOffset;
        }
        return 0.0;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Supplier<Block> torchSlabSupplier) {
        if (!PLACE_ENTRIES.containsKey(itemName) && torchSlabSupplier != null) {
            PLACE_ENTRIES.put(itemName, torchSlabSupplier);
        }
    }
}

