/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockPadCandle;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerPadCandle {
    private static final HashMap<ResourceLocation, Supplier<Block>> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)held.m_41720_());
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerPadCandle.placeCandle(event, held, PLACE_ENTRIES.get(rl).get());
        }
    }

    private static void placeCandle(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        Level world = event.getLevel();
        if (world.m_8055_(pos).m_60734_() instanceof WaterlilyBlock && face == Direction.UP) {
            world.m_46597_(pos, (BlockState)block.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)event.getEntity().m_6350_()));
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        } else if (world.m_8055_(pos).m_60734_() == block && (Integer)world.m_8055_(pos).m_61143_((Property)CandleBlock.f_152790_) < 4) {
            BlockState placeState = world.m_8055_(pos);
            world.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)placeState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)placeState.m_61143_((Property)BlockPadCandle.FACING)))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)((Boolean)placeState.m_61143_((Property)BlockPadCandle.f_152791_)))).m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf((Integer)placeState.m_61143_((Property)BlockPadCandle.f_152790_) + 1))).m_61124_((Property)CandleBlock.f_152792_, (Comparable)((Boolean)placeState.m_61143_((Property)BlockPadCandle.f_152792_))));
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getEntity());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getEntity().m_6674_(event.getHand());
            if (!event.getEntity().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Supplier<Block> padLightSupplier) {
        if (!PLACE_ENTRIES.containsKey(itemName) && padLightSupplier != null) {
            PLACE_ENTRIES.put(itemName, padLightSupplier);
        }
    }
}

