/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.fence_on_slab.mixin;

import com.matthewperiut.fence_on_slab.FenceOnSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public abstract class FenceBlockMixin
extends CrossCollisionBlock {
    @Unique
    protected VoxelShape[] lowerCollisionShapes = null;
    @Unique
    protected VoxelShape[] lowerBoundingShapes = null;

    @Shadow
    public abstract boolean m_53329_(BlockState var1, boolean var2, Direction var3);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(BlockBehaviour.Properties settings, CallbackInfo ci) {
        int i;
        this.lowerCollisionShapes = new VoxelShape[this.f_52315_.length];
        this.lowerBoundingShapes = new VoxelShape[this.f_52316_.length];
        for (i = 0; i < this.f_52315_.length; ++i) {
            this.lowerCollisionShapes[i] = this.f_52315_[i].m_83216_(0.0, -0.5, 0.0);
        }
        for (i = 0; i < this.f_52316_.length; ++i) {
            this.lowerBoundingShapes[i] = this.f_52316_[i].m_83216_(0.0, -0.5, 0.0);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FenceOnSlab.LOWER, (Comparable)Boolean.valueOf(false)));
    }

    protected FenceBlockMixin(float radius1, float radius2, float boundingHeight1, float boundingHeight2, float collisionHeight, BlockBehaviour.Properties settings) {
        super(radius1, radius2, boundingHeight1, boundingHeight2, collisionHeight, settings);
    }

    @Unique
    private boolean sameHalf(boolean lower, BlockState blockState) {
        if (blockState.m_60734_() instanceof FenceBlock) {
            return (Boolean)blockState.m_61143_((Property)FenceOnSlab.LOWER) == lower;
        }
        return true;
    }

    @Unique
    private boolean isLower(BlockState blockState) {
        if (blockState.m_60734_() instanceof SlabBlock) {
            return ((SlabType)blockState.m_61143_((Property)SlabBlock.f_56353_)).equals((Object)SlabType.BOTTOM);
        }
        if (blockState.m_60734_() instanceof FenceBlock) {
            return (Boolean)blockState.m_61143_((Property)FenceOnSlab.LOWER);
        }
        return false;
    }

    @Inject(method={"getPlacementState"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetPlacementState(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        try {
            if (!FenceOnSlab.FENCE_SLAB_SUPPORT.contains(this.m_7705_().split("\\.")[2])) {
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Report to Fence On Slab Github Issues");
            System.out.println(e.getMessage());
            return;
        }
        Level blockView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockPos blockPos2 = blockPos.m_122012_();
        BlockPos blockPos3 = blockPos.m_122029_();
        BlockPos blockPos4 = blockPos.m_122019_();
        BlockPos blockPos5 = blockPos.m_122024_();
        BlockState blockState = blockView.m_8055_(blockPos2);
        BlockState blockState2 = blockView.m_8055_(blockPos3);
        BlockState blockState3 = blockView.m_8055_(blockPos4);
        BlockState blockState4 = blockView.m_8055_(blockPos5);
        boolean lower = this.isLower(blockView.m_8055_(blockPos.m_7495_()));
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(this.sameHalf(lower, blockState) && this.m_53329_(blockState, blockState.m_60783_((BlockGetter)blockView, blockPos2, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(this.sameHalf(lower, blockState2) && this.m_53329_(blockState2, blockState2.m_60783_((BlockGetter)blockView, blockPos3, Direction.WEST), Direction.WEST)))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(this.sameHalf(lower, blockState3) && this.m_53329_(blockState3, blockState3.m_60783_((BlockGetter)blockView, blockPos4, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(this.sameHalf(lower, blockState4) && this.m_53329_(blockState4, blockState4.m_60783_((BlockGetter)blockView, blockPos5, Direction.EAST), Direction.EAST)))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)FenceOnSlab.LOWER, (Comparable)Boolean.valueOf(lower));
        cir.setReturnValue((Object)state);
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onStateForNeighborUpdate(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos, CallbackInfoReturnable<BlockState> cir) {
        try {
            if (!FenceOnSlab.FENCE_SLAB_SUPPORT.contains(this.m_7705_().split("\\.")[2])) {
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Report to Fence On Slab Github Issues");
            System.out.println(e.getMessage());
            return;
        }
        if (((Boolean)state.m_61143_((Property)f_52313_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        boolean lower = (Boolean)state.m_61143_((Property)FenceOnSlab.LOWER);
        if (direction.equals((Object)Direction.DOWN)) {
            lower = this.isLower(neighborState);
        }
        BlockState blockState = direction.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)state.m_61124_((Property)f_52314_.get(direction), (Comparable)Boolean.valueOf(this.sameHalf(lower, neighborState) && this.m_53329_(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction.m_122424_()), direction.m_122424_()))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        blockState.m_61124_((Property)FenceOnSlab.LOWER, (Comparable)Boolean.valueOf(lower));
        cir.setReturnValue((Object)blockState);
    }

    @Inject(method={"appendProperties"}, at={@At(value="TAIL")})
    private void injectExtraProperty(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.m_61104_(new Property[]{FenceOnSlab.LOWER});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)FenceOnSlab.LOWER)).booleanValue()) {
            return this.lowerCollisionShapes[this.m_52363_(state)];
        }
        return super.m_5939_(state, world, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)FenceOnSlab.LOWER)).booleanValue()) {
            return this.lowerBoundingShapes[this.m_52363_(state)];
        }
        return super.m_5940_(state, world, pos, context);
    }
}

