/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render.forge;

import com.berksire.furniture.client.render.FluidRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class FluidRendererImpl {
    public static void renderFluidBox(FluidStack archStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom) {
        Fluid fluid = archStack.getFluid();
        net.minecraftforge.fluids.FluidStack fluidStack = FluidStackHooksForge.toForge((FluidStack)archStack);
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.m_85836_();
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.m_85849_();
    }
}

