/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fionathemortal.betterbiomeblend.common.debug.Debug;
import fionathemortal.betterbiomeblend.common.debug.DebugSummary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class BetterBiomeBlendClient {
    public static OptionInstance<Integer> betterBiomeBlendRadius = new OptionInstance("options.biomeBlendRadius", OptionInstance.m_231498_(), (component, integer) -> {
        int diameter = integer * 2 + 1;
        return Options.m_231921_((Component)component, (Component)Component.m_237115_((String)("options.biomeBlendRadius." + diameter)));
    }, (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 14), (Object)14, integer -> Minecraft.m_91087_().f_91060_.m_109818_());

    public static int getBiomeBlendRadius() {
        return (Integer)betterBiomeBlendRadius.m_231551_();
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder benchmarkCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"betterbiomeblend").then(Commands.m_82127_((String)"toggleBenchmark").executes(context -> {
            boolean benchmarking = Debug.toggleBenchmark();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (benchmarking) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)"Started benchmark. Stop with /betterbiomeblend toggleBenchmark"), false);
                }
            } else {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)"Stopped benchmark"), false);
                }
                DebugSummary summary = Debug.collateDebugEvents();
                String[] lines = new String[]{"", String.format("Call Count: %d", summary.totalCalls), String.format("Wall Time: %.2f s", summary.elapsedWallTimeInSeconds), String.format("Calls/sec: %.2f", summary.callsPerSecond), String.format("Avg. CPU Time: %.2f ns", summary.averageTime), String.format("Avg. 1%%: %.2f ns", summary.averageOnePercentTime), String.format("Total CPU time: %.2f ms", summary.totalCPUTimeInMilliseconds), String.format("Total Subevent CPU time: %.2f ms", summary.totalSubeventCPUTimeInMilliseconds), String.format("Avg. Subevent CPU Time: %.2f ns", summary.averageSubeventTime), String.format("Avg. Subevent 1%%: %.2f ns", summary.averageSubeventOnePercent), ""};
                if (player != null) {
                    for (String line : lines) {
                        player.m_5661_((Component)Component.m_237113_((String)line), false);
                    }
                }
                Debug.teardown();
            }
            return 0;
        }));
        dispatcher.register(benchmarkCommand);
    }
}

