/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingGuideScreen;

public class EnchantingGuideMenu
extends GhostItemMenu<ItemStack> {
    private static final Component NO_ENCHANTMENT = EnchantmentIndustry.LANG.translate("gui.enchanting_guide.no_enchantment", new Object[0]).component();
    private ImmutableList<Component> previousEnchantments;
    ImmutableList<Component> enchantments = ImmutableList.of((Object)NO_ENCHANTMENT);
    boolean directItemStackEdit;
    @Nullable
    BlockPos blockPos = null;

    public EnchantingGuideMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
        this.directItemStackEdit = extraData.readBoolean();
        if (!this.directItemStackEdit) {
            this.blockPos = extraData.m_130135_();
        }
    }

    public EnchantingGuideMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder, @Nullable BlockPos blockPos) {
        super(type, id, inv, (Object)contentHolder);
        if (blockPos != null) {
            this.directItemStackEdit = false;
            this.blockPos = blockPos;
        } else {
            this.directItemStackEdit = true;
        }
    }

    private void updateEnchantments(ItemStack stack) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        this.enchantments = map.isEmpty() ? ImmutableList.of((Object)NO_ENCHANTMENT) : ImmutableList.copyOf((Object[])((Component[])map.entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue())).toArray(Component[]::new)));
        boolean resetIndex = this.previousEnchantments == null || !this.previousEnchantments.toString().equals(this.enchantments.toString());
        this.previousEnchantments = ImmutableList.copyOf(this.enchantments);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Screen patt2874$temp = Minecraft.m_91087_().f_91080_;
            if (patt2874$temp instanceof EnchantingGuideScreen) {
                EnchantingGuideScreen screen = (EnchantingGuideScreen)patt2874$temp;
                screen.updateScrollInput(resetIndex);
            }
        });
    }

    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(1);
    }

    protected boolean allowRepeats() {
        return true;
    }

    protected void initAndReadInventory(ItemStack contentHolder) {
        super.initAndReadInventory((Object)contentHolder);
        CompoundTag tag = contentHolder.m_41784_();
        if (tag.m_128425_("target", 10)) {
            ItemStack target = ItemStack.m_41712_((CompoundTag)tag.m_128469_("target"));
            this.ghostInventory.setStackInSlot(0, target);
            this.updateEnchantments(target);
        }
    }

    protected ItemStack createOnClient(FriendlyByteBuf extraData) {
        return extraData.m_130267_();
    }

    protected void addSlots() {
        this.addPlayerSlots(44, 70);
        this.m_38897_((Slot)new EnchantedBookSlot(0, 51, 22));
    }

    protected void saveData(ItemStack contentHolder) {
    }

    public boolean m_6875_(Player player) {
        if (!this.directItemStackEdit) {
            return super.m_6875_(player) && player.m_9236_().m_7702_(this.blockPos) instanceof BlazeEnchanterBlockEntity;
        }
        return super.m_6875_(player);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 36) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.m_142621_();
        if (clickTypeIn == ClickType.CLONE) {
            if (player.m_7500_() && held.m_41619_()) {
                ItemStack stackInSlot = this.ghostInventory.getStackInSlot(0).m_41777_();
                this.m_142503_(stackInSlot);
            }
        } else if (this.m_38853_(36).m_5857_(held) || held.m_41619_()) {
            this.ghostInventory.setStackInSlot(0, held.m_41777_());
            this.m_38853_(slotId).m_6654_();
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.m_8020_(index);
            if (this.m_38853_(36).m_5857_(stackToInsert)) {
                ItemStack copy = stackToInsert.m_41777_();
                this.ghostInventory.insertItem(0, copy, false);
                this.m_38853_(36).m_6654_();
            }
        } else {
            this.ghostInventory.extractItem(0, 1, false);
            this.m_38853_(index).m_6654_();
        }
        return ItemStack.f_41583_;
    }

    class EnchantedBookSlot
    extends SlotItemHandler {
        public EnchantedBookSlot(int index, int xPosition, int yPosition) {
            super((IItemHandler)EnchantingGuideMenu.this.ghostInventory, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack pStack) {
            return pStack.m_150930_(Items.f_42690_) && !EnchantmentHelper.m_44831_((ItemStack)pStack).isEmpty();
        }

        public void m_6654_() {
            super.m_6654_();
            EnchantingGuideMenu.this.updateEnchantments(this.m_7993_());
        }
    }
}

